<?php 
  session_start();

  $phpFile = $_SERVER["SCRIPT_NAME"];

  include 'includes/initTranslationConfig.php';
  include 'includes/initLogging.php';
 
  logMessage($log, 'info', 'COD', $phpFile . ': Entry ');


?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" lang="en-US">
<head>
	<meta charset="UTF-8" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	
	<title>Declaration-as-a-Service - <?php echo $tr->get('activation', 'activate') ?></title>
	
	<!-- Global styles -->
	<link rel="stylesheet" type="text/css" href="css/reset.css" />
	<link rel="stylesheet" type="text/css" href="css/grid.css" />
	<link rel="stylesheet" type="text/css" href="css/config.css" />

<!-- = Global Scripts [required for template] 
	***************************************************************************************-->
	<script type="text/javascript" src="js/jquery.js"></script>
	<script type="text/javascript" src="plugins/validator/js/languages/jquery.validationEngine-en.js"></script>
	<script type="text/javascript" src="plugins/validator/js/jquery.validationEngine.js"></script>
	<script>
		jQuery(document).ready(function(){
			jQuery("#admin_login_form").validationEngine('attach', {promptPosition : "bottomRight", autoPositionUpdate : true});
		});
	</script>
	
	
</head>
<body>
    <?php 
	// TODO: logging
	if (isset($_GET['email']) && isset($_GET['key'])) {
	    // Check if hash OK
	    if (strcmp(hash('sha256', $conf['general']['key_various'] . urldecode($_GET['email'])),urldecode($_GET['key'])) == 0) {
		// Open DB connection
		$mongo = new Mongo();
		$db = $mongo->declaas;
		$users = $db->users;


		// Check if activation asked
		$res = $users->findOne(array('uid' => $post_username, 'status' => 'pending'), array('uid'));
		
		if ($res['uid'] = '') {           
		    logMessage($log, 'info', 'COD', $phpFile . ': Activation requested but no request found for user ' . $_GET['email']);
		    header('login.php?activation_failed=1');
		    exit(0);
		}
		

		// TODO: check if not too long ago

		// Update database
		$users->update(array('uid' => $_GET['email']), array('$set' => array('status' => 'active')) );

		echo $tr->get('activation_succesful', 'activate');
		logMessage($log, 'info', 'BUSCAPSEC', $phpFile . ': Successful activation request for user ' . $_GET['email']);
		header('Location: login.php?activation_succeeded=1');
		exit(0);
	    } else {
		echo $tr->get('activation_failure', 'activate');
		logMessage($log, 'warn', 'COD', $phpFile . ': Fake activation (hash error) for user ' . $_GET['email']);
		header('Location: login.php?activation_failed=1');
		exit(0);
	    }
	} else {
    	    echo $tr->get('activation_failure', 'activate');
    	    logMessage($log, 'info', 'COD', $phpFile . ': Activation without parameters');
	    header('Location: login.php?activation_failed=1');
	    exit(0);
	}

    ?><br>
</body>
</html>
<?php 
  logMessage($log, 'info', 'COD', $phpFile . ': Exit ');
?>