<?php
include('log4php/Logger.php');

class Tenant extends CI_Controller {

    function __construct()
    {
	parent::__construct();
    }


    public function index() {
	$this->view('design_list');
    }



    public function view($page = 'design_list') {
	if ( ! file_exists('application/views/pages/tenant/'.$page.'.php')) {
	    // Whoops, we don't have a page for that!
	    show_404();
	}


	// PASS ON DATA
	$data['title'] = "Tenant - " . ucfirst($page); // Capitalize the first letter

	Logger::configure('config/log4php.xml');
	$data['log'] = Logger::getLogger('appLogger');

	$mongo = new Mongo();
	$db = $mongo->declaas;
	$data['mongo'] = $mongo;
	$data['db'] = $db;


	// TODO: check if correct user profile!
	$this->load->view('templates/head', $data);
	
	$data['gblTenant'] = $_SESSION['username'];
	// Check if 'tenant' user profile
	if ($_SESSION['type'] != 'tenant') {
//	    show_error('You do not have access to this area', 403);
	    header( 'Location: /declaas/login.php' ) ;
	}

	$this->load->view('templates/menu-tenant', $data);
	$this->load->view('pages/tenant/'.$page, $data);
	$this->load->view('templates/footer', $data);
	
    }

}
