<?php
// ***********************************************************************
// *********                     PREPARATION                    **********
// ***********************************************************************

    include '../includes/initLogging.php';
    include '../includes/checkSession.php';
    include '../includes/initMultiTenancy.php';
    
    mb_internal_encoding('UTF-8');
 


    /**
     * MongoDB connection
     */
     
    $database   = 'declaas';
    $collection = 'declarations';
    
    
    try {
	$m = new Mongo();
    } catch (MongoConnectionException $e) {
	die('Error connecting to MongoDB server');
    }
 
    $input =& $_GET;
 



// ***********************************************************************
// *********                      GET DATA                      **********
// ***********************************************************************


    $m_collection = $m->$database->$collection;


    /**
     * Determine total number of forms for the current tenant (TODO: inefficient... let's hope mongodb caches well...)
     */
    $searchTermTenant['form.tenant'] = $gblTenant;
    $noTenantDeclarations = $m_collection->find($searchTermTenant, array('id' => true))->count();


    /**
     * Define the document fields to return to DataTables (as in http://us.php.net/manual/en/mongocollection.find.php).
     * If empty, the whole document will be returned.
     */
    $fields = array('timestamp' => true , 'form.id' => true, 'auth.username' => true, 'followup.status' => true, 'data' => true);

    

    /**
     * Handle requested DataProps
     */
 
    // Number of columns being displayed (useful for getting individual column search info)
    $iColumns = $input['iColumns'];
 

    // Get mDataProp values assigned for each table column
    $dataProps = array();

    for ($i = 0; $i < $iColumns; $i++) {
        $var = 'mDataProp_'.$i;
	if (isset($input[$var]) && $input[$var] != 'null') {
    	    $dataProps[$i] = $input[$var];
        }
    }




// ***********************************************************************
// *********                  FILTER & SEARCH                   **********
// ***********************************************************************
 
    /**
     * Filtering
     * NOTE this does not match the built-in DataTables filtering which does it
     * word by word on any field. It's possible to do here, but concerned about efficiency
     * on very large collections.
     */
    $searchTermsAny = array();
    $searchTermsAll = array();
 
    if ( !empty($input['sSearch']) ) {
	$sSearch = $input['sSearch'];
     
	for ( $i=0 ; $i < $iColumns ; $i++ ) {
    	    if ($input['bSearchable_'.$i] == 'true') {
        	if ($input['bRegex'] == 'true') {
            	    $sRegex = str_replace('/', '\/', $sSearch);
        	} else {
            	    $sRegex = preg_quote($sSearch, '/');
        	}
        	
        	$searchTermsAny[] = array(
            	    $dataProps[$i] => new MongoRegex( '/'.$sRegex.'/i' )
        	);
    	    }
	}
    }


 
    // Individual column filtering
    for ( $i=0 ; $i < $iColumns ; $i++ ) {
	if ( $input['bSearchable_'.$i] == 'true' && $input['sSearch_'.$i] != '' ) {
    	    if ($input['bRegex_'.$i] == 'true') {
        	$sRegex = str_replace('/', '\/', $input['sSearch_'.$i]);
            } else {
	        $sRegex = preg_quote($input['sSearch_'.$i], '/');
    	    }
            $searchTermsAll[ $dataProps[$i] ] = new MongoRegex( '/'.$sRegex.'/i' );
	}
    }
    

    // No terms specified 
    $searchTerms = $searchTermsAll;
    if (!empty($searchTermsAny)) {
	$searchTermsOr['$or'] = $searchTermsAny;
    }


    // Tenant filter
    if (!empty($searchTermsOr)) {
	$searchTerms['$and'] = array(array('form.tenant' => $gblTenant), $searchTermsOr);
    } else {
	$searchTerms['form.tenant'] = $gblTenant;
    }


    // Form filter (combobox in declaration_list)
    if (!empty($input['formId'])) {
	$searchTerms['$and'] = array(array('form.id' => $input['formId']), $searchTerms);
    }



// ***********************************************************************
// *********                   PAGING & ORDER                   **********
// ***********************************************************************

    // Go and find in MongoDB 
    $cursor = $m_collection->find($searchTerms, $fields);


 
    /**
     * Paging
     */
    if ( isset( $input['iDisplayStart'] ) && $input['iDisplayLength'] != '-1' ) {
	$cursor->limit( $input['iDisplayLength'] )->skip( $input['iDisplayStart'] );
    }

  
    /**
     * Ordering
     */

    if ( isset($input['iSortCol_0']) ) {
	$sort_fields = array();
        for ( $i=0 ; $i<intval( $input['iSortingCols'] ) ; $i++ ) {
	    if ( $input[ 'bSortable_'.intval($input['iSortCol_'.$i]) ] == 'true' ) {
                $field = $dataProps[ intval( $input['iSortCol_'.$i] ) ];
                $order = ( $input['sSortDir_'.$i]=='desc' ? -1 : 1 );
                $sort_fields[$field] = $order;
	    }
        }
	$cursor->sort($sort_fields);
    }




// ***********************************************************************
// *********                DATA EXTRACTION PREP                **********
// ***********************************************************************

    /**
     * Retrieve what fields to extract for each form!
     */

    $tblForms = $m->$database->forms;
    
    $cursorForms = $tblForms->find(array('tenant' => $gblTenant), array('id' => true, 'extract' => true));
    
    foreach ($cursorForms as $res) {
	if (isset($res['extract'])) {
    	    $fieldsToExtract[$res['id']] = $res['extract'];
    	} else {
    	    $fieldsToExtract[$res['id']] = '';
    	}
    	
    }


    /**
     * Function to extract wanted fields from data field 
     */	
     
    function getExtract ($argData, $argFieldsToExtract) {
	if (preg_match('/,/', $argFieldsToExtract)) {
	    $arrFields = split(',', $argFieldsToExtract);
	} else {
	    $arrFields[0] = $argFieldsToExtract;
	}
    
	$r = '';
	foreach ($arrFields as $f) {
	    $f = trim($f);

	    if (!empty($argData[$f])) {
		$r .= '<strong>' . $f . '</strong>: ' . $argData[$f] . '<br/>';
	    }
	}

	return $r;
    }
     
    


// ***********************************************************************
// *********                       OUTPUT                       **********
// ***********************************************************************

    $output = array(
	'sEcho' => intval($input['sEcho']),
        'iTotalRecords' => $noTenantDeclarations, 
        'iTotalDisplayRecords' => $cursor->count(),
        'aaData' => array(),
    );


    foreach ( $cursor as $doc ) {
	// 1. Extract $id and put into DT_RowId variable
        $doc['DT_RowId'] = $doc['_id']->{'$id'};
    
	// 2. Remove from regular 'data' array
        unset($doc['_id']);
    
        // 3. Process data (extraction + encoding)
        $doc['data'] = getExtract($doc['data'], $fieldsToExtract[$doc['form']['id']]);
        
	// 4. Convert into human readable date
        $doc['timestamp'] = date('c', $doc['timestamp']->sec);

        // 5. Preset non-existent fields to empty (mongoDB doesn't return a field if it wasn't set -- adaption because of difference between mongodb and a traditional rdbms) 
        // TODO: a bit crappy...
	foreach ($fields as $f => $v) {
	    if (!isset($doc[$f])) {
		$doc[$f] = '';
    	    }
        }

        // 5. Add to output
        $output['aaData'][] = $doc;
    }

    echo json_encode( $output );
