<?php
include '../includes/initLogging.php';
include '../includes/checkSessionUser.php';

/**
 * Script:    DataTables server-side script for PHP 5.2+ and MongoDB
 * Copyright: 2012 - Kari Söderholm, aka Haprog
 * License:   GPL v2 or BSD (3-point)
 *
 * By default Mongo documents are returned as is like they are stored in the
 * database. You can define which fields to return by overriding the empty
 * $fields array a few rows below.
 *
 * Because MongoDB documents can naturally contain nested data, this script
 * assumes (requires) that you use mDataProp in DataTables to define which
 * fields to display.
 */
 

// TODO: sort & search doen werken
mb_internal_encoding('UTF-8');
 
$database   = 'declaas';
$collection = 'forms';


/**
 * MongoDB connection
 */
try {
    $m = new Mongo();
} catch (MongoConnectionException $e) {
    die('Error connecting to MongoDB server');
}
 
$m_collection = $m->$database->$collection;


/**
 * Determine total number of forms for the current tenant (TODO: inefficient... let's hope mongodb caches well...)
 */
//$searchTermTenant['tenant'] = $gblTenant;
//$noTenantForms = $m_collection->find($searchTermTenant, array('id' => true))->count();


/**
 * Define the document fields to return to DataTables (as in http://us.php.net/manual/en/mongocollection.find.php).
 * If empty, the whole document will be returned.
 */
$fields = array('id' => true , 'auth' => true, 'title' => true, 'tenant' => true);


 
// Input method (use $_GET, $_POST or $_REQUEST)
$input =& $_GET;


/**
 * Handle requested DataProps
 */
 
// Number of columns being displayed (useful for getting individual column search info)
$iColumns = $input['iColumns'];
 

// Get mDataProp values assigned for each table column
$dataProps = array();

for ($i = 0; $i < $iColumns; $i++) {
    $var = 'mDataProp_'.$i;
    if (isset($input[$var]) && $input[$var] != 'null') {
        $dataProps[$i] = $input[$var];
    }
}

 
/**
 * Filtering
 * NOTE this does not match the built-in DataTables filtering which does it
 * word by word on any field. It's possible to do here, but concerned about efficiency
 * on very large collections.
 */
$searchTermsAny = array();
$searchTermsAll = array();
 
if ( !empty($input['sSearch']) ) {
    $sSearch = $input['sSearch'];
     
    for ( $i=0 ; $i < $iColumns ; $i++ ) {
        if ($input['bSearchable_'.$i] == 'true') {
            if ($input['bRegex'] == 'true') {
                $sRegex = str_replace('/', '\/', $sSearch);
            } else {
                $sRegex = preg_quote($sSearch, '/');
            }
            $searchTermsAny[] = array(
                $dataProps[$i] => new MongoRegex( '/'.$sRegex.'/i' )
            );
//            $searchTermsAny[$dataProps[$i]] = new MongoRegex( '/'.$sRegex.'/i' );
        }
    }
}

 
// Individual column filtering
for ( $i=0 ; $i < $iColumns ; $i++ ) {
    if ( $input['bSearchable_'.$i] == 'true' && $input['sSearch_'.$i] != '' ) {
        if ($input['bRegex_'.$i] == 'true') {
            $sRegex = str_replace('/', '\/', $input['sSearch_'.$i]);
        } else {
            $sRegex = preg_quote($input['sSearch_'.$i], '/');
        }
        $searchTermsAll[ $dataProps[$i] ] = new MongoRegex( '/'.$sRegex.'/i' );
    }
}
 
$searchTerms = $searchTermsAll;
if (!empty($searchTermsAny)) {
    $searchTermsOr['$or'] = $searchTermsAny;
}


//logMessage($log, 'info', 'COD', $phpFile . ': Ajax GET with search terms "' . print_r($searchTerms, true) . '"');


// Go and find in MongoDB 
$cursor = $m_collection->find($searchTerms, $fields);

 
/**
 * Paging
 */
if ( isset( $input['iDisplayStart'] ) && $input['iDisplayLength'] != '-1' ) {
    $cursor->limit( $input['iDisplayLength'] )->skip( $input['iDisplayStart'] );
}
  
/**
 * Ordering
 */

if ( isset($input['iSortCol_0']) ) {
    $sort_fields = array();
    for ( $i=0 ; $i<intval( $input['iSortingCols'] ) ; $i++ ) {
        if ( $input[ 'bSortable_'.intval($input['iSortCol_'.$i]) ] == 'true' ) {
            $field = $dataProps[ intval( $input['iSortCol_'.$i] ) ];
            $order = ( $input['sSortDir_'.$i]=='desc' ? -1 : 1 );
            $sort_fields[$field] = $order;
        }
    }
    $cursor->sort($sort_fields);
}

/**
 * Determine order of the fields
 */

/*foreach ($cursor as $doc) {
    unset($doc['_id']);
    print_r ($doc);
} 
*/
  
/**
 * Output
 */
$output = array(
    'sEcho' => intval($input['sEcho']),
    'iTotalRecords' => $m_collection->count(),
    'iTotalDisplayRecords' => $cursor->count(),
    'aaData' => array(),
);
 
foreach ( $cursor as $doc ) {
    // 1. Extract $id and put into DT_RowId variable
    $doc['DT_RowId'] = $doc['_id']->{'$id'};
    
    // 2. Remove from regular 'data' array
    unset($doc['_id']);
    
    // 3. Preset non-existent fields to empty (mongoDB doesn't return a field if it wasn't set -- adaption because of difference between mongodb and a traditional rdbms) 
    // TODO: a bit crappy...
    foreach ($fields as $f => $v) {
	if (!isset($doc[$f])) {
	    $doc[$f] = '';
	}
    }

    // 4. Add to output
    $output['aaData'][] = $doc;
}

//file_put_contents("/tmp/test", json_encode($output));
 
echo json_encode( $output );
