<?php
include '../includes/initLogging.php';
include '../includes/checkSession.php';
include '../includes/initMultiTenancy.php';
                                           

// Determine action
// TODO: clean up, what a mess!!

// Constants (TODO: move to 'configuration')
$auth_html = "\n// Check (end-user) authentication.\ninclude '/home/ftd/public_html/fairtradedesign.be/declaas/includes/checkSessionUser.php';";



if (empty($_POST['id'])) {exit();};

    // ****************************************************************************************************
    // ******************                        FASE I: PREPARATION                     ******************
    // ****************************************************************************************************

    // --- Get data from MongoDB ---
	$mongo = new Mongo();
        $db = $mongo->declaas;
        $tblForms = $db->forms;
        $searchCrit = array('id' => $_POST['id'], 'tenant' => $gblTenant);

	$res = $tblForms->findOne($searchCrit, array('deploy' => 1, 'redirect' => 1, 'auth' => 1, 'sign' => 1));
        
        
    // --- Set properties right ---
	$output_directory = rtrim(dirname(__FILE__), 'application') . '/your_forms';
        $default_width = 500;
        $rules = isset($res['deploy']['rules']) ? $res['deploy']['rules'] : '';
        $form_html = isset($res['deploy']['form_html']) ? $res['deploy']['form_html'] : false;
        $form_width = (isset($res['deploy']['width']) ? $res['deploy']['width'] : $default_width) . 'px';
        $theme = isset($res['deploy']['theme']) ? $res['deploy']['theme'] : 'default';
        $datesRanges = $res['deploy']['dates_ranges'];
        $redirect_url = isset($res['redirect']) ? $res['redirect'] : 'http://www.smals.be';
        $auth_type = isset($res['auth']) ? $res['auth']: 'public'; // default public
    	    
    // --- The directory of the the theme specific resources ---
	$theme_resources_directory = 'form_resources/themes/' . $theme . '/';

    // --- Output names structure for created form/zip ---
    $file_names = array(
    	'html' => 'index.php',
    	'css' => 'css/style.css',
    	'js' => 'js/main.js',
    	'php' => 'process_form.php',
    	'tools-js' => 'js/jquery.tools.js',
    	'uniform-js' => 'js/jquery.uniform.min.js',
    	'uniform-css' => 'css/uniform.css'
    );





    // ****************************************************************************************************
    // ******************         FASE II: CREATE FILES & DIRS in temp location          ******************
    // ****************************************************************************************************

    // --------------------
    // -- 1. Create dirs --
    // --------------------
	
	$form_directory = time();

	//Set up the directory structure for the new form
        // TODO: error boodschap minder verbose (for security)
        if (!mkdir("$output_directory/$form_directory", 0777, true))
        die('Unable to create a new folder for the form. Please check write permissions on the \'your_forms\' folder. They should be 777. Dir is currently set to "' . "$output_directory/$form_directory"  . '"');

        mkdir("$output_directory/$form_directory/js", 0777);
        mkdir("$output_directory/$form_directory/css", 0777);
        mkdir("$output_directory/$form_directory/images", 0777);
    


    // ---------------------------------------
    // -- 2. form_template.php => index.php --
    // ---------------------------------------
    
        //prepare the form
	$form_template = file_get_contents('form_resources/form_template.php');
        $form_html = stripslashes(str_replace('${form}', $form_html, $form_template));
    
	// enable authentication if needed
        if ($auth_type != 'public') {
    	    $form_html = str_replace('${user-auth}', $auth_html, $form_html);
	} else {
	    $form_html = str_replace('${user-auth}', '', $form_html);
	}
	
	// Activate prefilling!
	$form_html = preg_replace('/input\s+name\s*=\s*"prefill_(\w+)"/','input name="prefill_$1" value=<?php echo \'"\'. getPrefillValue("' . $gblTenant . '", "prefill_$1") . \'"\'; ?>' , $form_html);
	

	//write form to file
	$fp = fopen("$output_directory/$form_directory/" . $file_names['html'], 'w');
	fwrite($fp, $form_html);
	fclose($fp);



    // ------------------
    // -- 3. css files --
    // ------------------
                         
	//prepare the css
	$form_width_css = "\n\n.TTWForm{\n \twidth: $form_width;\n}\n";

	$css_template = file_get_contents($theme_resources_directory . 'css/style.css');
	$form_css = stripslashes(str_replace('${form_width}', $form_width_css, $css_template));


	//write the css to the file
	$fp = fopen("$output_directory/$form_directory/" . $file_names['css'], 'w');
	fwrite($fp, $form_css);
	fclose($fp);



    // ------------------------------------------------------
    // -- 4. process_form_template.php => process_form.php --
    // ------------------------------------------------------
    
	// prepare the server side validation script (do necessary replacements)
	$rules = format_rules($rules);
	$rules = print_array($rules);

    
	$sss_template = file_get_contents('form_resources/process_form_template.php');
        $sss = str_replace('${rules}', $rules, $sss_template);
        $sss = str_replace('${redirect}', $redirect_url , $sss);



	// enable authentication if needed
        if ($auth_type != 'public') {
    	    $sss = str_replace('${user-auth}', $auth_html, $sss);
	} else {
	    $sss = str_replace('${user-auth}', '', $sss);
	}



	// authentication: try to fill in username, even if public 
	$strF = 'empty($_SESSION[\'username\'])?\'nobody\':$_SESSION[\'username\']';
	$sss  = str_replace('${user-name}', $strF, $sss);

	$sss = str_replace('${user-auth-type}', '\'' . $auth_type . '\'', $sss);
	$sss = str_replace('${form-tenant}', '\'' . $gblTenant . '\'', $sss);
	$sss = str_replace('${form-id}', '\'' . $_POST['id'] . '\'', $sss);


        // signing with eID?
        if (!empty($res['sign'])) {
	    $sss = str_replace('${sign}', $res['sign'], $sss);
	} else {
	    $sss = str_replace('${sign}', '0', $sss);
	}

	// write server side script to file
        $fp = fopen("$output_directory/$form_directory/" . $file_names['php'], 'w');
	fwrite($fp, $sss);
        fclose($fp);

    
    // ------------------------------------------------------
    // -- 5. Create js script                              --
    // ------------------------------------------------------


        //Handle Date and Range Inputs
        $dates_ranges = $datesRanges;

	$date_ids = !empty($dates_ranges['date']) ? '#' . trim(implode(', #', explode(' ', trim($dates_ranges['date']))), ',') : null;
        $range_ids = !empty($dates_ranges['range']) ? '#' . trim(implode(', #', explode(' ', trim($dates_ranges['range']))), ',') : null;

	$date_js = isset($date_ids) ? '$("' . $date_ids . '").dateinput();' : null;
        $range_js = isset($range_ids) ? '$("' . $range_ids . '").rangeinput();' : null;

	$date_range_js = (isset($date_js) && isset($range_js)) ? "\n\t" . $date_js . "\n\n\t" . $range_js . "\n" : "\n\t" . $date_js . $range_js;
        $date_range_js = (!empty($date_range_js) ? "//Date and Range Inputs" : '') . $date_range_js;


	//copy form dependencies @@@
        $js_template = file_get_contents('form_resources/js/main.js');
        $js = stripslashes(str_replace('${date_range_inputs}', $date_range_js, $js_template));

	if (!empty($res['sign'])) { // Do sign
	    $js = str_replace('${redirect}', 'http://www.fairtradedesign.be/declaas/backend/dss_sign.php' , $js);
	} else {
	    $js = str_replace('${redirect}', $redirect_url , $js);
	}


        //write js script to file
        $fp = fopen("$output_directory/$form_directory/" . $file_names['js'], 'w');
        fwrite($fp, $js);
        fclose($fp);


    
    // ------------------------------------------------------
    // -- 6. Copy static (image) files                     --
    // ------------------------------------------------------

	$dir_to = "$output_directory/$form_directory/";
    
	copy('form_resources/js/jquery.tools.js', $dir_to . $file_names['tools-js']);
        copy('form_resources/js/jquery.uniform.min.js', $dir_to . $file_names['uniform-js']);
	copy($theme_resources_directory . 'css/uniform.' . $theme . '.css', $dir_to . $file_names['uniform-css']);

	foreach (glob('form_resources/themes/' . $theme . '/images/*') as $filename) {
	    
    	    copy($filename, $dir_to . 'images/' . end(explode('/', $filename)));
        }
        
    // '



    // ****************************************************************************************************
    // ******************         FASE III: COPY TO DEPLOY LOCATION                      ******************
    // ****************************************************************************************************
    
	if (!file_exists("/home/ftd/public_html/fairtradedesign.be/deploys/acc/$gblTenant/")) 
    	    mkdir("/home/ftd/public_html/fairtradedesign.be/deploys/acc/$gblTenant/");
    	    
    	if (!file_exists("/home/ftd/public_html/fairtradedesign.be/deploys/acc/$gblTenant/" . $_POST['id'])) 
	    mkdir("/home/ftd/public_html/fairtradedesign.be/deploys/acc/$gblTenant/" . $_POST['id'], 0777, true); 

        recurse_copy ("$output_directory/$form_directory", "/home/ftd/public_html/fairtradedesign.be/deploys/acc/$gblTenant/" . $_POST['id']);
	
	// Delete the temporary data
        deleteDir ("$output_directory/$form_directory");

    
        logMessage($log, 'info', 'CAPBUS', $phpFile . ': Deploy to ACC done for tenant "' . $gblTenant . '" of form "' . $_POST['id']  . '"');

        exit();

    




    function format_rules($r)
    {
        $field_rules = $r;

        $formatted_rules = '';

        if (is_array($field_rules))
        {
            foreach ($field_rules as $field => $rules)
            {
                $formatted_rules[$field] = '';
                //           echo $field;
                foreach ($rules as $rule => $value)
                {
                    if ($rule == 'required')
                        $formatted_rules[$field] .= 'required|';
                    else if ($rule == 'type')
                    {
                        if ($value == 'email' || $value == 'number')
                            $formatted_rules[$field] .= $value . '|';
                    }
                    else
                    {
                        $formatted_rules[$field] .= $rule . '[' . $value . ']|';
                    }
                }
                $formatted_rules[$field] = rtrim($formatted_rules[$field], '|');
            }
        }

        return $formatted_rules;
    }





    function print_array($array, $indent = 1)
    {
        if (!is_array($array))
            return false;

        $array_string = "array(\n";

        foreach ($array as $key => $value)
            $array_string .= str_repeat("\t", $indent) . "'$key'=>'$value',\n";

        $array_string = trim($array_string, ",\n");

        $array_string .= "\n" . str_repeat("\t", $indent - 1) . ")";

        return $array_string;
    }





    function recurse_copy($src, $dst)
    {
        $dir = opendir($src);
        @mkdir($dst);
        while (false !== ($file = readdir($dir)))
        {
            if (($file != '.') && ($file != '..'))
            {
                if (is_dir($src . '/' . $file))
                {
                    recurse_copy($src . '/' . $file, $dst . '/' . $file);
                }
                else
                {
                    copy($src . '/' . $file, $dst . '/' . $file);
                }
            }
        }
        closedir($dir);
    }


    function deleteDir($dirPath) {
	if (! is_dir($dirPath)) {
    	    throw new InvalidArgumentException('$dirPath must be a directory');
        }
        
        if (substr($dirPath, strlen($dirPath) - 1, 1) != '/') {
            $dirPath .= '/';
        }
        
        $files = glob($dirPath . '*', GLOB_MARK);
        
        foreach ($files as $file) {
            if (is_dir($file)) {
                deleteDir($file);
            } else {
                unlink($file);
            }
        }
        rmdir($dirPath);
    }


    function delete_form($dir)
    {
	foreach(glob($dir . '/*') as $file) {
            if(is_dir($file))
                rmdir($file);
            else
                unlink($file);
        }
        rmdir($dir);
    }





    function manual_download($handle)
    {
        if (opendir($output_directory . '/' . $handle))
        {
            $links = "<div id='manual-download'>Files (click save as):<br/><br/>";

            $form_files = $getDirectoryTree('../your_forms/' . $handle);

            $links .= $form_files['index.html'];
            $links .= $form_files['process_form.php'];

            $links .= "<h5>css</h5>";
            $links = $print_folder($form_files['css'], $links);

            $links .= "<h5>images</h5>";
            $links = $print_folder($form_files['images'], $links);

            $links .= "<h5>js</h5>";
            $links = $print_folder($form_files['js'], $links);

            $links .= '</div>';

            return $links;
        }
    }





    function print_folder($folder,  $links )
    {
        foreach($folder as $file)
             $links .= $file;

        return $links;
    }

    function getDirectoryTree($outerDir)
    {
        $dirs = array_diff(scandir($outerDir), Array(".", ".."));
        $dir_array = Array();
        foreach ($dirs as $d)
        {
            if (is_dir($outerDir . "/" . $d)) $dir_array[$d] = $getDirectoryTree($outerDir . "/" . $d);
            else $dir_array[$d] = "<a href='" . trim($outerDir."/".$d, '.,/') . "' target='_blank'>$d</a>";
        }
        return $dir_array;
    }





    function pre($data)
    {
        echo "<pre>";
        print_r($data);
        echo "</pre>";
    }

?>