<?php
// ***********************************************************************
// *********                     PREPARATION                    **********
// ***********************************************************************

    include '../includes/initLogging.php';
    include '../includes/checkSession.php';
    include '../includes/initMultiTenancy.php';
    
    // Initialization
    $phpFile = $_SERVER["SCRIPT_NAME"];
    
    // UTF-8 encoding
    mb_internal_encoding('UTF-8');


    /**
     * MongoDB connection
     */
     
    $database   = 'declaas';
    $collection = 'declarations';
    
    
    try {
	$m = new Mongo();
    } catch (MongoConnectionException $e) {
	die('Error connecting to MongoDB server');
    }
 
    $input =& $_GET;
 



// ***********************************************************************
// *********                      GET DATA                      **********
// ***********************************************************************

    // --- Which data to extract and from which collection ---
    $tblDeclarations = $m->$database->$collection;
    $fields 		= array('timestamp' => true , 
				'form.id' => true, 
				'auth.username' => true, 
				'followup.status' => true, 
				'data' => true);



    // --- Search criteria ---
    $searchCriteria = array('form.tenant' => $gblTenant);

    if (!empty($input['field_form'])) $searchCriteria['form.id'] = $input['field_form'];

    if (!empty($input['field_excel_status'])) $searchCriteria['followup.status'] = $input['field_excel_status'];

    if (empty($input['field_excel_timespan']) || $input['field_excel_timespan'] == 0) {  // alle nog niet gedownloade
	$searchCriteria['export.excel.exported'] = array('$ne' => 'true');
    } elseif ($input['field_excel_timespan'] > 0)  {
	$fromDate =  new MongoDate(time()- 60*$input['field_excel_timespan']);
	$searchCriteria['timestamp'] = array('$gt' => $fromDate);
    } // in de andere gevallen (-1 bv): alle records binnenhalen

    // TODO: bugje
    

    // Log and fetch data    
    logMessage($log, 'info', 'COD', $phpFile . ': ' . json_encode($searchCriteria));
    $cursor = $tblDeclarations->find($searchCriteria, $fields);

    if ($cursor->count() == 0) {
	logMessage($log, 'info', 'COD', $phpFile . ': No records found for export with search criteria "' . json_encode($searchCriteria) . '"');
	
	header('Location: /declaas/index.php/tenant/export_form?noresults=1');
	exit(0);
    }



// ***********************************************************************
// *********             FILL EXCEL DATA STRUCTURE              **********
// ***********************************************************************

    $noRows=0;    
    $noCols=4;
    
    // Column headers
    $cell[0][0] = "Timestamp";
    $cell[0][1] = "Form ID";
    $cell[0][2] = "Username";
    $cell[0][3] = "Status";
    $cell[0][4] = "Data";
    
    // Data    
    foreach ($cursor as $res) {
	$noRows++;
	$cell[$noRows][0] = date('c', $res['timestamp']->sec);
	$cell[$noRows][1] = $res['form']['id'];
	$cell[$noRows][2] = $res['auth']['username'];
	$cell[$noRows][3] = $res['followup']['status'];
	$cell[$noRows][4] = json_encode($res['data']);
    }
    



// ***********************************************************************
// *********                 CREATE EXCEL FILE                  **********
// ***********************************************************************

    header("Content-type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=excel.xls");

    echo "<table>\n";
    for ($i = 0; $i <= $noRows; $i++) {
	echo "<tr>\n";
	
	for ($j = 0; $j <= $noCols; $j++) {
	    echo "<td>" . $cell[$i][$j] . "</td>";
	}
	echo "</tr>\n";
    }
    
    echo "</table>\n";




// ***********************************************************************
// *********                UPDATE EXPORT STATUS                **********
// ***********************************************************************
    
    if (empty($input['field_excel_timespan']) || $input['field_excel_timespan'] == 0) {  // only if "new" selected
	$statement = array('$set' =>  array('export.excel.exported' => 'true'));
				  	  
	$tblDeclarations->update($searchCriteria, $statement, array('multiple' => true)); // do upserts, do multi
    }
    
    
    
    logMessage($log, 'info', 'BUSCAP', $phpFile . ': Exported data for form, type "' . $input['field_excel_timespan'] . '" records.');


    exit(0);
    
?>