<?php
// Load necessary includes
include '/home/ftd/public_html/fairtradedesign.be/declaas/includes/initTranslationConfig.php';
include '/home/ftd/public_html/fairtradedesign.be/declaas/includes/initLogging.php';
include '/home/ftd/public_html/fairtradedesign.be/declaas/includes/initDatabase.php';

session_start();




$form = new ProcessForm($db, $log);
$form->field_rules = array(
	'fieldText'=>'required',
	'fieldStory'=>'required',
	'fieldSelect'=>'required',
	'fieldRadio'=>'required',
	'field_checkbox'=>'required'
);
$form->validate();

class ProcessForm
{
    public $field_rules;
    public $error_messages;
    public $fields;
    private $error_list;
    private $is_xhr;

    // Added
    private $form_tenant;
    private $form_id;
    private $user_auth; // The authentication that the user did
    private $user_name;
    private $vDb;
    private $vLog;


    function __construct($db, $log)
    {
    
	// Validation stuff
        $this->error_messages = array(
            'required' => 'This field is required',
            'email' => 'Please enter a valid email address',
            'number' => 'Please enter a numeric value',
            'url' => 'Please enter a valid URL',
            'pattern' => 'Please correct this value',
            'min' => 'Please enter a value larger than the minimum value',
            'max' => 'Please enter a value smaller than the maximum value'
        );
        
	// Pass log & db var
	$this->vDb = $db;
	$this->vLog = $log;
	$this->phpFile = $_SERVER["SCRIPT_NAME"];;

        // Internal variables
        $this->field_rules = array();
        $this->error_list = '';
        $this->fields = $_POST;
        $this->is_xhr = $this->xhr();
        
        $this->form_tenant = 'johan.loeckx@smals.be';
        $this->form_id = 'frmTest';
        
        $this->user_auth = 'public';
        $this->user_name = empty($_SESSION['username'])?'nobody':$_SESSION['username'];
    }




    function validate()
    {
        if (!empty($this->fields))
        {
            //Validate each of the fields
            foreach ($this->field_rules as $field => $rules)
            {
                $rules = explode('|', $rules);

                foreach ($rules as $rule)
                {
                    $result = null;

                    if (isset($this->fields[$field]))
                    {
                        $param = false;

                        if (preg_match("/(.*?)\[(.*?)\]/", $rule, $match))
                        {
                            $rule = $match[1];
                            $param = $match[2];
                        }

                        $this->fields[$field] = $this->clean($this->fields[$field]);

                        //if the field is a checkbox group create string
                        if (is_array($this->fields[$field]))
                            $this->fields[$field] = implode(', ', $this->fields[$field]);

                        // Call the function that corresponds to the rule
                        if (!empty($rule))
                            $result = $this->$rule($this->fields[$field], $param);

                        // Handle errors
                        if ($result === false)
                            $this->set_error($field, $rule);
                    }
                }
            }

            if (empty($this->error_list))
            {
                if ($this->is_xhr)
                    echo json_encode(array('status' => 'success'));

                $this->process();
            }
            else
            {
                if ($this->is_xhr)
                    echo json_encode(array('status' => 'invalid', 'errors' => $this->error_list));
                else echo $this->error_list;
            }
        }
    }





    function process()
    {
         /**
         * SUCCESS!!
         * There were no errors in the form. Insert your processing logic here (i.e. send an email, save to a
         * database etc.
         *
         * All of the submitted fields are available in the $this->fields variable.
         *
         *
         * IMPORTANT - PLEASE READ:
         * 1. YOU MUST UNCOMMENT THE CODE FOR IT TO WORK.
         *    - This means removing the '//' in front of each line.
         *    - If you do not know what php comments are see here: http://php.net/manual/en/language.basic-syntax.comments.php
         *
         * 2. YOU CAN ENTER ANY EMAIL ADDRESS IN THE $from VARIABLE.
         *    - This is the address that will show in the From column in your mail application.
         *    - If your form contains an email field, and you want to use that value as the $from variable, you can set $from = $this->fields['name of your email field'];
         *
         * 3. FILE ATTACHMENTS
         *    - As stated in the description on codecanyon, this code does not mail attachments. Google 'php html email attachments' for information on how to do this
         *
         *  4. REDIRECTING TO ANOTHER PAGE AFTER SUBMISSION
         *    - This is an ajax enabled form, so you need to perform the redirection in main.js AND this php file.
         *      a. Please see instructions in main.js for redirection. This is for users without JS.
         *      b. Replace the relevant code below with the page you would like to redirect to. REMEMBER TO UNCOMMENT THE LINE FOR IT TO WORK.
         */


	 /*********************************************/
         /*             SAVE TO mongoDB               */
         /*********************************************/
	 $declarations = $this->vDb->declarations;
	 $res = $declarations->save(array('form' 	=> array('tenant' 	=> $this->form_tenant,
								 'id'		=> $this->form_id),
					  'auth' 	=> array('username'	=> $this->user_name,
								 'type'	=> $this->user_auth),
					  'followup' 	=> array('status'	=> 'submitted'),
					  'timestamp' 	=> date('c'),
					  'data'    	=> $this->fields
				   ));



         /*********************************************/
         /*          GEEN WORKFLOW HIER!!!            */
         /*********************************************/

	 // Loskoppelen van workflow; in deze file enkel opslaan in database + loggen
	 // Mail etc kan elders

	
         // $msg = "Form Contents: \n\n";
         // foreach($this->fields as $key => $field)
         //       $msg .= "$key :  $field \n";

         // $to = 'emailaddress@domain.com';
         // $subject = 'Form Submission';
         // $from = 'emailaddress@domain.com';

         // mail($to, $subject, $msg, "From: $from\r\nReply-To: $from\r\nReturn-Path: $from\r\n");


         /*********************************************/
         /*                    LOG                    */
         /*********************************************/
         
         logMessage($this->vLog, 'info', 'BUSCAP', $this->phpFile . ': Declaration of type "' . $this->form_id . '" created by user "' . $this->user_name . '" for tenant "' . $this->form_tenant . '" using "' . $this->user_auth . '" authentication' );


        /************************************************************************************/
        /*                                REDIRECTION CODE                                  */
        /*         Only uncomment the line below if you want to redirect to another page    */
        /*                          when the form has been submitted                        */
        /************************************************************************************/

        if (!$this->is_xhr)
	      header("Location: http://www.smals.be");


    }



    function set_error($field, $rule)
    {
        if ($this->is_xhr)
        {
            $this->error_list[$field] = $this->error_messages[$rule];
        }
        else $this->error_list .= "<div class='error'>$field: " . $this->error_messages[$rule] . "</div>";
    }





    function xhr()
    {
        return (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') ? true : false;
    }





    /** Validation Functions */
    function required($str, $val = false)
    {

        if (!is_array($str))
        {
            $str = trim($str);
            return ($str == '') ? false : true;
        }
        else
        {
            return (!empty($str));
        }
    }

    function email($str)
    {
        return (!preg_match("/^(?!(?:(?:\\x22?\\x5C[\\x00-\\x7E]\\x22?)|(?:\\x22?[^\\x5C\\x22]\\x22?)){255,})(?!(?:(?:\\x22?\\x5C[\\x00-\\x7E]\\x22?)|(?:\\x22?[^\\x5C\\x22]\\x22?)){65,}@)(?:(?:[\\x21\\x23-\\x27\\x2A\\x2B\\x2D\\x2F-\\x39\\x3D\\x3F\\x5E-\\x7E]+)|(?:\\x22(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x21\\x23-\\x5B\\x5D-\\x7F]|(?:\\x5C[\\x00-\\x7F]))*\\x22))(?:\\.(?:(?:[\\x21\\x23-\\x27\\x2A\\x2B\\x2D\\x2F-\\x39\\x3D\\x3F\\x5E-\\x7E]+)|(?:\\x22(?:[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x21\\x23-\\x5B\\x5D-\\x7F]|(?:\\x5C[\\x00-\\x7F]))*\\x22)))*@(?:(?:(?!.*[^.]{64,})(?:(?:(?:xn--)?[a-z0-9]+(?:-[a-z0-9]+)*\\.){1,126}){1,}(?:(?:[a-z][a-z0-9]*)|(?:(?:xn--)[a-z0-9]+))(?:-[a-z0-9]+)*)|(?:\\[(?:(?:IPv6:(?:(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){7})|(?:(?!(?:.*[a-f0-9][:\\]]){7,})(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,5})?::(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,5})?)))|(?:(?:IPv6:(?:(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){5}:)|(?:(?!(?:.*[a-f0-9]:){5,})(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,3})?::(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,3}:)?)))?(?:(?:25[0-5])|(?:2[0-4][0-9])|(?:1[0-9]{2})|(?:[1-9]?[0-9]))(?:\\.(?:(?:25[0-5])|(?:2[0-4][0-9])|(?:1[0-9]{2})|(?:[1-9]?[0-9]))){3}))\\]))$/iD", $str)) ? false : true;
    }

    function number($str)
    {
        return (!is_numeric($str)) ? false : true;
    }

    function min($str, $val)
    {
        return ($str >= $val) ? true : false;
    }

    function max($str, $val)
    {
        return ($str <= $val) ? true : false;
    }

    function pattern($str, $pattern)
    {
        return (!preg_match($pattern, $str)) ? false : true;
    }





    function clean($str)
    {
        $str = is_array($str) ? array_map(array("ProcessForm", 'clean'), $str) : str_replace('\\', '\\\\', strip_tags(trim(htmlspecialchars((get_magic_quotes_gpc() ? stripslashes($str) : $str), ENT_QUOTES))));
        return $str;
    }
}


?>