<?php

// Logging function
function logMessage($objLog, $level, $categories, $message) {
    // construct level
    $msg = str_pad(session_id(),26) . " - ";
    if (isset($_SESSION['username'])) {
	$msg .= str_pad($_SESSION['username'],25);
    } else {
	$msg .= str_pad('',25);
    }
    $msg .= "|". str_pad($categories, 15) . "| " . $message;

    // write log entry
    switch ($level) {
	case 'debug': $objLog->debug ($msg); break;
	case 'info': $objLog->info ($msg); break;
	case 'warn': $objLog->warn ($msg); break;
	case 'error': $objLog->error ($msg); break;
	case 'fatal': $objLog->fatal ($msg); break;
    }
}

?>
