<?php include 'head.php'; ?>

	
			<section id="container" class="container_12">
			
			
				<!-- ======= .grid_12 - block begin ======= -->
				<section class="grid_12">
					<div class="box">
						<div class="title"><div class="layout">Accordion</div></div>						
						<div class="inside">
							<div class="in">
							
							<div class="clear"></div>
							<a href="zTabs.php" class="button alignleft"><span class="icon16_sprite_green i_arrowhead_left"></span>Tabs</a>
							<a href="zCharts.php" class="button alignright"><span class="icon16_sprite_green b_right i_arrowhead_right"></span>Charts</a>
							<div class="clear"></div>
							
							<h4 class="docs_title_first">Accordion</h4>
							
							<p>Accordion are generally used to break content into multiple sections that can be swapped to save space, like tabs.</p>
							
							<p><strong>How to create an Accordion?</strong></p>
							<p><strong>1. Initialize the plugin</strong></p>
<pre>jQuery(function() {
	jQuery( ".ui_accordion" ).accordion({
		active: false, //Selector for the active element. Set to false to display none at start. Needs collapsible: true.
		collapsible: true, //Whether all the sections can be closed at once.
		autoHeight: false, //If set, the highest content part is used as height reference for all other parts. 
		navigation: true //If set, looks for the anchor that matches location.href and activates it.
	});
});</pre><br />
							<p><strong>2. Create the HTML using the same class from the code above:</strong></p><br />
  							
<pre>&lt;div class="ui_accordion">
	...
&lt;/div></pre><br />                          
							
							<p><strong>3 Create first section. Here is the structure of a single section:</strong></p><br />
							
<pre>&lt;h3>&lt;a href="#">My section title&lt;/a>&lt;/h3>
&lt;div>
	&lt;p> Here is all my content for this section &lt;/p>
&lt;/div></pre><br />

							<p><strong>4 Final code:</strong></p><br />
							
<pre>&lt;div class=<code>"ui_accordion"</code>>

	<code>&lt;h3></code>&lt;a href="#">My section title 1&lt;/a><code>&lt;/h3></code>
	<code>&lt;div></code>&lt;p> Here is all my content for my section 1 &lt;/p><code>&lt;/div></code>

	<code>&lt;h3></code>&lt;a href="#">My section title 2&lt;/a><code>&lt;/h3></code>
	<code>&lt;div></code>&lt;p> Here is all my content for my section 2 &lt;/p><code>&lt;/div></code>

	<code>&lt;h3></code>&lt;a href="#">My section title 3&lt;/a><code>&lt;/h3></code>
	<code>&lt;div></code>&lt;p>  Here is all my content for my section 3 &lt;/p><code>&lt;/div></code>

&lt;/div></pre><br />



							
							<div class="docs_result"><span class="docsR_title">The result of the code above:</span>						
								<div class="ui_accordion">

									<h3><a href="#">My section title 1</a></h3>
									<div><p> Here is all my content for my section 1 </p></div>

									<h3><a href="#">My section title 2</a></h3>
									<div><p> Here is all my content for my section 2 </p></div>

									<h3><a href="#">My section title 3</a></h3>
									<div><p>  Here is all my content for my section 3 </p></div>

								</div>
								<div class="clear"></div>
							</div>
							<div class="clear"></div>
							
							
							
							
		
							<br />
							<h5 class="docs_title_first">Options</h5><br />
							
							<div class="box">
								<div class="title">Main Options</div>								
								<div class="inside">
									<table cellpadding="0" cellspacing="0" border="0" class="display" id="datatable_1docs">
										<thead>
											<tr>
												<th width="15%">OPTION</th>
												<th width="15%">TYPE</th>
												<th width="15%">DEFAULT</th>
												<th width="65%">DESCRIPTION</th>
											</tr>
										</thead>
										<tbody>
										
											<tr class="gradeA odd">
												<td><code>disabled</code></td>  <td><code>Boolean</code></td>  <td><code>false</code></td>
												<td> Disables (true) or enables (false) the accordion. Can be set when initialising (first creating) the accordion. </td>
											</tr>
											
											<tr class="gradeA even">
												<td><code>active</code></td>  <td><code>Selector</code>, <code>Element</code>, <code>jQuery</code>, <code>Boolean</code>, <code>Number</code></td>  <td><code>first child</code></td>
												<td> Selector for the active element. Set to false to display none at start. Needs <code>collapsible: true</code>. </td>
											</tr>
											

											<tr class="gradeA odd">
												<td><code>animated</code></td>  <td><code>Boolean</code>, <code>String</code></td>  <td><code>'slide'</code></td>
												<td> Choose your favorite animation, or disable them (set to false). In addition to the default, 'bounceslide' and all defined easing methods are supported ('bounceslide' requires UI Effects Core). </td>
											</tr>
											
											<tr class="gradeA even">
												<td><code>autoHeight</code></td>  <td><code>Boolean</code></td>  <td><code>true</code></td>
												<td> If set, the highest content part is used as height reference for all other parts. Provides more consistent animations. </td>
											</tr>

											

											<tr class="gradeA odd">
												<td><code>collapsible</code></td>  <td><code>Boolean</code></td>  <td><code>false</code></td>
												<td> Whether all the sections can be closed at once. Allows collapsing the active section by the triggering event (click is the default). </td>
											</tr>
											
											<tr class="gradeA even">
												<td><code>event</code></td>  <td><code>String</code></td>  <td><code>'click'</code></td>
												<td> The event on which to trigger the accordion. </td>
											</tr>
											

											<tr class="gradeA odd">
												<td><code>fillSpace</code></td>  <td><code>Boolean</code></td>  <td><code>false</code></td>
												<td> If set, the accordion completely fills the height of the parent element. Overrides autoheight. </td>
											</tr>
											
											<tr class="gradeA even">
												<td><code>header</code></td>  <td><code>Selector</code>, <code>jQuery</code></td>  <td><code>'> li > :first-child,> :not(li):even'</code></td>
												<td> Selector for the header element. </td>
											</tr>
											

											<tr class="gradeA odd">
												<td><code>icons</code></td>  <td><code>Object</code></td>  <td><code>{ 'header': 'ui-icon-triangle-1-e', 'headerSelected': 'ui-icon-triangle-1-s' }</code></td>
												<td> Icons to use for headers. Icons may be specified for 'header' and 'headerSelected'. Set to <code>false</code> to have no icons displayed. </td>
											</tr>
											
											<tr class="gradeA even">
												<td><code>navigation</code></td>  <td><code>Boolean</code></td>  <td><code>true</code></td>
												<td> If set, looks for the anchor that matches location.href and activates it. Great for href-based state-saving. Use navigationFilter to implement your own matcher. </td>
											</tr>
											
											
											
											<tr class="gradeA odd">
												<td><code>navigationFilter</code></td>  <td><code>Function</code></td>  <td></td>
												<td> Overwrite the default location.href-matching with your own matcher. </td>
											</tr>
																					
											
											
										</tbody>
										<tfoot>
											<tr>
												<th>OPTION</th>
												<th>TYPE</th>
												<th>DEFAULT</th>
												<th>DESCRIPTION</th>
											</tr>
										</tfoot>
									</table>								
									<div class="clear"></div>
								</div>
							</div>
							
							
							<!-- Reference -->
							<div class="docs_refer">
								<strong>Reference:</strong><br /> 
								<ul>
								<li><a href="http://jqueryui.com/demos/accordion/" target="_blank">http://jqueryui.com/demos/accordion/</a> - JQueryUI Accordion plugin official website. For more options and examples, please follow this link. </li>
								</ul>
							</div>
							<!-- /Reference -->
							
							
							<div class="clear"></div>
							<a href="zTabs.php" class="button alignleft"><span class="icon16_sprite_green i_arrowhead_left"></span>Tabs</a>
							<a href="zCharts.php" class="button alignright"><span class="icon16_sprite_green b_right i_arrowhead_right"></span>Charts</a>
							<div class="clear"></div>
							</div>
						</div>
					</div>
				</section>
				<div class="clear"></div>
				<!-- ======= .grid_12 - block end ======= -->
				
				
			</section><!-- End of #container -->
			

			
<?php include 'footer.php'; ?>