<?php include 'head.php'; ?>

	
			<section id="container" class="container_12">
			
			
				<!-- ======= .grid_12 - block begin ======= -->
				<section class="grid_12">
					<div class="box">
						<div class="title"><div class="layout">Charts</div></div>						
						<div class="inside">
							<div class="in">
							
							<div class="clear"></div>
							<a href="zAccordion.php" class="button alignleft"><span class="icon16_sprite_green i_arrowhead_left"></span>Accordion</a>
							<a href="zDataTables.php" class="button alignright"><span class="icon16_sprite_green b_right i_arrowhead_right"></span>Data Tables</a>
							<div class="clear"></div>
							
							<h4 class="docs_title_first">Charts</h4>
							
							<p class="grid_6">Charts from this template use Flotr2 library. Flotr2 is a library for drawing HTML5 charts and graphs.  It is a branch of <a title="flotr" href="http://code.google.com/p/flotr/" target="_blank">flotr</a> which removesthe Prototype dependency and includes many improvements.
							
							</p>
							
							<p class="grid_6">
							  To use Flotr2, include the <code>flotr2.min.js</code> script in your page and
							  create a visible <code>&lt;div&gt;</code> with positive width and height.
							  <br />A graph is drawn with the <code>Flotr.draw(container, data, options)</code>
							  method.
							</p><div class="clear"></div>
							
							<h5 class="docs_title_first">Features</h5>
							</p><div class="clear"></div>
								
								<div class="grid_6">
								<ul>
									<li>mobile support</li>
									<li>framework independent</li>
									<li>extensible plugin framework</li>
									<li>custom chart types</li>
									<li>FF, Chrome, IE6+, Android, iOS</li>
								</ul>
								</div>
								<div class="grid_6">
								<ol>
									<li>lines</li>
									<li>bars</li>
									<li>candles</li>
									<li>pies</li>
									<li>bubbles</li>
								</ol>
								</div>
							</p><div class="clear"></div>
							
							
							
							<h5 class="docs_title">How to create a Chart?</h5>
							
							
							<p><strong>1. Create a new function, in this mode:</strong></p>
<pre>(function () {

  // Some code to be here...
  
})();</pre><br />

							<p><strong>2. Define some variables. </strong></p>
<pre>var
	container = document.getElementById('my_graph_example_doc'), //Container ID
	d1 = [[0, 2], [1, 0],[2, 12], [3, 10], [4, 9],[4.5, 11], [5, 9],[7, 12],[8, 8], [9, 16]], // First data series
	d2 = [[0, 0],[1, 5], [2, 3], [3, 6], [4, 3.5],[5, 8], [6, 3.9], [7, 9], [8, 6], [9, 10]],  // Second data series
	graph; //This variable allow us to draw the chart. Add also other variables here, separated by comma(,)</pre><br />
	
							<p><em>Data series work in this mode</em>: 
							
<pre>
newVariable = [[X<sub>1</sub>, Y<sub>1</sub>], [X<sub>2</sub>, Y<sub>2</sub>],[X<sub>3</sub>, Y<sub>3</sub>], ..., [X<sub>n</sub>, Y<sub>n</sub>]]
</pre><br />							
							</p>
							

							<p><strong>3. Create the graph:</strong></p>
<pre><code>graph</code> = Flotr.draw(container, [ d1, d2], {

	//Options here
	
  });</pre><br />

							

							<p><strong>3. Add some options:</strong></p>
<pre><code>graph</code> = Flotr.draw(container, [ d1, d2], {

	xaxis: {
	  minorTickFreq: 4 	// number of minor ticks between major ticks for autogenerated ticks
	}, //end of xaxis
	
	grid: {
	  minorVerticalLines	: true 	// whether to show gridlines in vertical direction. <code>true</code> or <code>false</code>
	}, //end of grid
	
	mouse: {
	  track: true,  // true to track the mouse, no tracking otherwise
	  radius: 13,  // radius of the track point
	}, //end of mouse
	
	colors: ['#CE4D60', '#9851CE'],  // Some custom colors(optional). // end of colors
	shadowSize: 0, //My preference, to set graph shadow to 0.  // end of shadowSize
	
  });</pre><br />
  
  

							<p><strong>4. Final code:</strong></p>
<pre>(function () {

var
	container = document.getElementById('<code>my_graph_example_doc</code>'), //Container ID
	d1 = [[0, 2], [1, 0],[2, 12], [3, 10], [4, 9],[4.5, 11], [5, 9],[7, 12],[8, 8], [9, 16]], // First data series
	d2 = [[0, 0],[1, 5], [2, 3], [3, 6], [4, 3.5],[5, 8], [6, 3.9], [7, 9], [8, 6], [9, 10]],  // Second data series
	graph; //This variable allow us to draw the chart. Add also other variables here, separated by comma(,)
	
graph = Flotr.draw(container, [ d1, d2], {

	xaxis: {
	  minorTickFreq: 4 	// number of minor ticks between major ticks for autogenerated ticks
	}, //end of xaxis
	
	grid: {
	  minorVerticalLines	: true 	// whether to show gridlines in vertical direction. true or false
	}, //end of grid
	
	mouse: {
	  track: true,  // true to track the mouse, no tracking otherwise
	  radius: 13,  // radius of the track point
	}, //end of mouse
	
	colors: ['#CE4D60', '#9851CE'],  // Some custom colors(optional). // end of colors
	shadowSize: 0, //My preference, to set graph shadow to 0.  // end of shadowSize
	
  });
  
})();</pre><br />



							<p><strong>5. Create the graph in a DIV with the ID from initialization script <code>"my_graph_example_doc"</code> and a valid <em>width</em> and <em>height</em> :</strong></p>

<pre><br /> &lt;div id=<code>"my_graph_example_doc"</code> style="<code>width: 100%</code>; <code>height: 200px</code>">&lt;/div>
<br /></pre><br />




							<div class="docs_result"><span class="docsR_title">FINAL RESULT:</span>		
										
									<div id="my_graph_example_doc" style="width: 100%; height: 200px;"></div>
									
								</form><br/>
							</div>
							<div class="clear"></div>



<script>
//<![CDATA[
(function () {

var
	container = document.getElementById('my_graph_example_doc'), //Container ID
	d1 = [[0, 2], [1, 0],[2, 12], [3, 10], [4, 9],[4.5, 11], [5, 9],[7, 12],[8, 8], [9, 16]], // First data series
	d2 = [[0, 0],[1, 5], [2, 3], [3, 6], [4, 3.5],[5, 8], [6, 3.9], [7, 9], [8, 6], [9, 10]],  // Second data series
	graph; //This variable allow us to draw the chart. Add also other variables here, separated by comma(,)
	
graph = Flotr.draw(container, [ d1, d2 ], {

	xaxis: {
	  minorTickFreq: 4 	// number of minor ticks between major ticks for autogenerated ticks
	}, //end of xaxis
	
	grid: {
	  minorVerticalLines: true 	// whether to show gridlines in vertical direction. true or false
	}, //end of grid
	
	mouse: {
	  track: true,  // true to track the mouse, no tracking otherwise
	  radius: 13,  // radius of the track point
	}, //end of mouse
	
	colors: ['#CE4D60', '#9851CE'],  // Some custom colors(optional). // end of colors
	shadowSize: 0, //My preference, to set graph shadow to 0.  // end of shadowSize
	
  });
  
})();
//]]>
</script>

							<br />
							<div class="clear"></div>
							<h5 class="docs_title">It's good to know!</h5>
							<div class="clear"></div>

							<p><strong>Basically you can create a chart with zero options. Pretty cool :)   Bellow is an example of the same graph but without any options.</strong></p>
<pre>(function () {

var
	container = document.getElementById('<code>my_graph_example_doc2</code>'), //Container ID
	d1 = [[0, 2], [1, 0],[2, 12], [3, 10], [4, 9],[4.5, 11], [5, 9],[7, 12],[8, 8], [9, 16]], // First data series
	d2 = [[0, 0],[1, 5], [2, 3], [3, 6], [4, 3.5],[5, 8], [6, 3.9], [7, 9], [8, 6], [9, 10]],  // Second data series
	graph; //This variable allow us to draw the chart. Add also other variables here, separated by comma(,)
	
graph = Flotr.draw(container, [ d1, d2]);
  
})();</pre><br />




							<div class="docs_result"><span class="docsR_title">RESULT:</span>		
										
									<div id="my_graph_example_doc2" style="width: 100%; height: 200px;"></div>
									
								</form><br/>
							</div>
							<div class="clear"></div>
							
							
<script>
//<![CDATA[
(function () {

var
	container = document.getElementById('my_graph_example_doc2'), //Container ID
	d1 = [[0, 2], [1, 0],[2, 12], [3, 10], [4, 9],[4.5, 11], [5, 9],[7, 12],[8, 8], [9, 16]], // First data series
	d2 = [[0, 0],[1, 5], [2, 3], [3, 6], [4, 3.5],[5, 8], [6, 3.9], [7, 9], [8, 6], [9, 10]],  // Second data series
	graph; //This variable allow us to draw the chart. Add also other variables here, separated by comma(,)
	
graph = Flotr.draw(container, [ d1, d2 ]);
  
})();
//]]>
</script>


							
							<br />
							<div class="clear"></div>
							<h4 class="docs_title">Options</h4>
							<div class="clear"></div>
							
							<br />
							
<pre>(/**
 * Flotr Defaults
 */
Flotr.defaultOptions = {
  colors: ['#00A8F0', '#C0D800', '#CB4B4B', '#4DA74D', '#9440ED'], //=> The default colorscheme. When there are > 5 series, additional colors are generated.
  ieBackgroundColor: '#FFFFFF', // Background color for excanvas clipping
  title: null,             // => The graph's title
  subtitle: null,          // => The graph's subtitle
  shadowSize: 4,           // => size of the 'fake' shadow
  defaultType: null,       // => default series type
  HtmlText: true,          // => wether to draw the text using HTML or on the canvas
  fontColor: '#545454',    // => default font color
  fontSize: 7.5,           // => canvas' text font size
  resolution: 1,           // => resolution of the graph, to have printer-friendly graphs !
  parseFloat: true,        // => whether to preprocess data for floats (ie. if input is string)
  xaxis: {
    ticks: null,           // => format: either [1, 3] or [[1, 'a'], 3]
    minorTicks: null,      // => format: either [1, 3] or [[1, 'a'], 3]
    showLabels: true,      // => setting to true will show the axis ticks labels, hide otherwise
    showMinorLabels: false,// => true to show the axis minor ticks labels, false to hide
    labelsAngle: 0,        // => labels' angle, in degrees
    title: null,           // => axis title
    titleAngle: 0,         // => axis title's angle, in degrees
    noTicks: 5,            // => number of ticks for automagically generated ticks
    minorTickFreq: null,   // => number of minor ticks between major ticks for autogenerated ticks
    tickFormatter: Flotr.defaultTickFormatter, // => fn: number, Object -> string
    tickDecimals: null,    // => no. of decimals, null means auto
    min: null,             // => min. value to show, null means set automatically
    max: null,             // => max. value to show, null means set automatically
    autoscale: false,      // => Turns autoscaling on with true
    autoscaleMargin: 0,    // => margin in % to add if auto-setting min/max
    color: null,           // => color of the ticks
    mode: 'normal',        // => can be 'time' or 'normal'
    timeFormat: null,
    scaling: 'linear',     // => Scaling, can be 'linear' or 'logarithmic'
    base: Math.E,
    titleAlign: 'center',
    margin: true           // => Turn off margins with false
  },
  x2axis: {},
  yaxis: {
    ticks: null,           // => format: either [1, 3] or [[1, 'a'], 3]
    minorTicks: null,      // => format: either [1, 3] or [[1, 'a'], 3]
    showLabels: true,      // => setting to true will show the axis ticks labels, hide otherwise
    showMinorLabels: false,// => true to show the axis minor ticks labels, false to hide
    labelsAngle: 0,        // => labels' angle, in degrees
    title: null,           // => axis title
    titleAngle: 90,        // => axis title's angle, in degrees
    noTicks: 5,            // => number of ticks for automagically generated ticks
    minorTickFreq: null,   // => number of minor ticks between major ticks for autogenerated ticks
    tickFormatter: Flotr.defaultTickFormatter, // => fn: number, Object -> string
    tickDecimals: null,    // => no. of decimals, null means auto
    min: null,             // => min. value to show, null means set automatically
    max: null,             // => max. value to show, null means set automatically
    autoscale: false,      // => Turns autoscaling on with true
    autoscaleMargin: 0,    // => margin in % to add if auto-setting min/max
    color: null,           // => The color of the ticks
    scaling: 'linear',     // => Scaling, can be 'linear' or 'logarithmic'
    base: Math.E,
    titleAlign: 'center',
    margin: true           // => Turn off margins with false
  },
  y2axis: {
    titleAngle: 270
  },
  grid: {
    color: '#545454',      // => primary color used for outline and labels
    backgroundColor: null, // => null for transparent, else color
    backgroundImage: null, // => background image. String or object with src, left and top
    watermarkAlpha: 0.4,   // => 
    tickColor: '#DDDDDD',  // => color used for the ticks
    labelMargin: 3,        // => margin in pixels
    verticalLines: true,   // => whether to show gridlines in vertical direction
    minorVerticalLines: null, // => whether to show gridlines for minor ticks in vertical dir.
    horizontalLines: true, // => whether to show gridlines in horizontal direction
    minorHorizontalLines: null, // => whether to show gridlines for minor ticks in horizontal dir.
    outlineWidth: 1,       // => width of the grid outline/border in pixels
    outline : 'nsew',      // => walls of the outline to display
    circular: false        // => if set to true, the grid will be circular, must be used when radars are drawn
  },
  mouse: {
    track: false,          // => true to track the mouse, no tracking otherwise
    trackAll: false,
    position: 'se',        // => position of the value box (default south-east)
    relative: false,       // => next to the mouse cursor
    trackFormatter: Flotr.defaultTrackFormatter, // => formats the values in the value box
    margin: 5,             // => margin in pixels of the valuebox
    lineColor: '#FF3F19',  // => line color of points that are drawn when mouse comes near a value of a series
    trackDecimals: 1,      // => decimals for the track values
    sensibility: 2,        // => the lower this number, the more precise you have to aim to show a value
    trackY: true,          // => whether or not to track the mouse in the y axis
    radius: 3,             // => radius of the track point
    fillColor: null,       // => color to fill our select bar with only applies to bar and similar graphs (only bars for now)
    fillOpacity: 0.4       // => opacity of the fill color, set to 1 for a solid fill, 0 hides the fill 
  }
};
)(document.getElementById("graphid_here"));</pre><br />

							
							<!-- Reference -->
							<div class="docs_refer">
								<strong>Reference:</strong><br /> 
								<ul>
								<li><a href="http://humblesoftware.com/flotr2/" target="_blank">http://humblesoftware.com/flotr2/</a> - Flotr2 official website. For more options and examples, please follow this link. </li>
								</ul>
							</div>
							<!-- /Reference -->
							
							
							<div class="clear"></div>
							<a href="zAccordion.php" class="button alignleft"><span class="icon16_sprite_green i_arrowhead_left"></span>Accordion</a>
							<a href="zDataTables.php" class="button alignright"><span class="icon16_sprite_green b_right i_arrowhead_right"></span>Data Tables</a>
							<div class="clear"></div>
							</div>
						</div>
					</div>
				</section>
				<div class="clear"></div>
				<!-- ======= .grid_12 - block end ======= -->
				
				
			</section><!-- End of #container -->
			

			
<?php include 'footer.php'; ?>