<?php include 'head.php'; ?>

	
			<section id="container" class="container_12">
			
			
				<!-- ======= .grid_12 - block begin ======= -->
				<section class="grid_12">
					<div class="box">
						<div class="title"><div class="layout">HTML Structure</div></div>						
						<div class="inside">
							<div class="in">
							
							<div class="clear"></div>
							<a href="zForms.php" class="button alignright"><span class="icon16_sprite_green b_right i_arrowhead_right"></span>Forms</a>
							<div class="clear"></div>
							
							<h4 class="docs_title_first">HTML Structure</h4>
							<p>This template is based on 960 grid system (fluid version). Main template parts are &quot;The header&quot; and &quot;The content&quot;.<br /><br />
							<strong>Here is the HTML structure for a single page:</strong></p>
								
<pre>&lt;!DOCTYPE html>
&lt;html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" lang="en-US">
    &lt;head>
		HEAD SCRIPTS AND STYLES
    &lt;/head>
    &lt;body>		
		&lt;section id="layout">
			&lt;div class="logo_profile container_12">
				&lt;div class="grid_6 logo_img">
					&lt;img src="images/logo.png" alt="Logo" />
				&lt;/div>
				&lt;div class="grid_6 profile_meta">
					PROFILE META
				&lt;/div>
				&lt;/div>
				&lt;div class="clear">&lt;/div>
			&lt;/div>
			&lt;section id="top">
				&lt;section id="top_bar">						
					&lt;section id="main_menu">
						MAIN MENU							
					&lt;div class="clear">&lt;/div>
					&lt;/section>&lt;!-- End of #main_menu -->
				&lt;/section>&lt;!-- End of #top_bar -->
				&lt;div class="clear">&lt;/div>
				&lt;section class="top_in">	
					&lt;section id="second_top_bar">
						QUICK TASK ICONS MENU					
					&lt;/section>&lt;!-- End of #second_top_bar -->
				&lt;/section>&lt;!-- End of .top_in -->
			&lt;/section>&lt;!-- End of #top -->
			&lt;section id="container" class="container_12">
				MAIN CONTENT			
			&lt;/section>&lt;!-- End of #container -->
		&lt;/section>&lt;!-- End of #layout -->
		&lt;div class="clear">&lt;/div>
		&lt;section id="footer_bar">
			FOOTER CONTENT
		&lt;/section>		
		OTHER SCRIPTS AND STYLES		
    &lt;/body>
&lt;/html></pre>
							<h5 class="docs_title">What's that?</h5>
							<p>OK. The code above can look a bit strange, so, let me explain every element.</p>
							<p>I think you know what must be included between <code>&lt;head&gt;&lt;/head&gt;</code>
							, so, I will not stay here to explain. I will start directly at <code>&lt;body&gt;</code>. Anyway, I will explain for every plugin/script/element if require or not some code to be included between <code>&lt;head&gt;</code> tags. </p>
							<p>We have &quot;top part&quot;, &quot;middle part&quot;, and &quot;bottom part&quot;. These parts include:</p>
							<ul>
							  <li> top part:<em> logo, current user meta, main menu and quick tast icons.</em></li>
							  <li>middle part: <em>all content.</em></li>

							  <li>bottom part: <em>currently only a copyright notice. You can add everything you want here (for ex.: another menu.)</em></li>
							</ul>
							
							<p>
							<strong>NOTE:</strong><br />
							 - "top part" and "middle part" are included into a section<span class="text-red">*</span> whith class <code>"layout"</code><br />
							 - "bottom part" come after this section<br />
							 <span class="text-red">*</span> <em>you can use <code>div</code> tag instead of <code>section</code>. Section tag is specific for HTML5.</em>
							</p>
							
							<h4 class="docs_title">Top part </h4>
								<p>"Top part" consists of two main elements: </p>
								<p><strong>Logo and user profile meta</strong></p>
<pre>&lt;div class="logo_profile container_12">
    &lt;div class="grid_6 logo_img">
        &lt;img src="images/logo.png" alt="Logo" />
    &lt;/div>
    &lt;div class="grid_6 profile_meta">
        PROFILE META
    &lt;/div>
    &lt;/div>
    &lt;div class="clear">&lt;/div>
&lt;/div></pre><br />


								<p><strong>Main menu and quick task icons</strong></p>
								<p>These two elements must be included into a section(or div) with ID <code>"top"</code></p>
<pre>&lt;section id="top">
	&lt;!-- Here will be the menu and quick task icons -->
&lt;/section></pre><br />

								<p><strong>Main menu structure:</strong></p>
<pre>&lt;section id="top_bar">						
	&lt;section id="main_menu">
		MAIN MENU							
	&lt;div class="clear">&lt;/div>
	&lt;/section>&lt;!-- End of #main_menu -->
&lt;/section>&lt;!-- End of #top_bar -->
&lt;div class="clear">&lt;/div></pre>
							
							<p>The menu is based on SuperFish script.</p>
							
							<!-- Reference -->
							<div class="docs_refer">
								<strong>Reference:</strong><br /> 
								<ul>
								<li><a href="http://users.tpg.com.au/j_birch/plugins/superfish/" target="_blank">http://users.tpg.com.au/j_birch/plugins/superfish/</a>   - Superfish plugin official website </li>
								
								</ul>
							</div>
							<!-- /Reference -->
							
							<p>It require to include these lines in template <code>&lt;head></code> </p>

<pre>&lt;script type="text/javascript" src="js/global_plugins_scripts.js">&lt;/script>
&lt;script type="text/javascript" src="js/head_scripts.js">&lt;/script></pre><br />
							
							<p><code>global_plugins_scripts.js</code> - contain the plugin script and other required scripts.<br />
							<code>head_scripts.js</code> - contain a piece of code which initialize the menu. Below is shown how this code look:</p>

<pre>/*
---------------------------------
	Main Menu
---------------------------------
*/
 $(document).ready(function(){ 
	$("ul.sf-menu").supersubs({ 
		minWidth:    15,  // minimum width of sub-menus in em units
		maxWidth:    20,  // maximum width of sub-menus in em units
		extraWidth:  1 	  // extra width can ensure lines don't sometimes turn over 
                          // due to slight rounding differences and font-family 
	}).superfish({
		delay:	0,  //delay on mouseout, in miliseconds (1 sec = 1000 miliseconds)
		animation: {height:'show'}  //the animation. This will slide down. For fade-in use this -> opacity:'show'
	});
});</pre><br />
							
							
	
							<p><strong>The menu structure looks like this:</strong></p>
<pre>&lt;ul class="sf-menu">
	&lt;li>&lt;a href="index.php">Dashboard&lt;/a>&lt;/li>
	&lt;li>&lt;a href="#">Item 1 level 1&lt;/a>&lt;/li>
	&lt;li>&lt;a href="#">Item 2 level 1&lt;/a>&lt;/li>
	&lt;li>&lt;a href="#">Item 3 level 1&lt;/a>
		&lt;ul>
			&lt;li>&lt;a href="#">Item 1 level 2&lt;/a>&lt;/li>
			&lt;li>&lt;a href="#">Item 2 level 2&lt;/a>&lt;/li>
			&lt;li>&lt;a href="#">Item 3 level 2&lt;/a>
				&lt;ul>
					&lt;li>&lt;a href="#">Item 1 level 3&lt;/a>&lt;/li>
					&lt;li>&lt;a href="#">Item 2 level 3&lt;/a>&lt;/li>
					&lt;li>&lt;a href="#">Item 3 level 3&lt;/a>&lt;/li>
				&lt;/ul>
			&lt;/li>&lt;!-- End of item 3 level 2 -->
		&lt;/ul>
	&lt;/li>&lt;!-- End of item 3 level 1 -->
&lt;/ul>&lt;!-- End of .sf-menu --></pre>


							<h4 class="docs_title">Middle part</h4>
							<p>"Middle part" is the most important part. Here is show all content from a specific page. His structure looks so:</p>
<pre>&lt;section id="container" class="container_12">
	MAIN CONTENT			
&lt;/section>&lt;!-- End of #container --></pre><br />
							
							<div class="alignright docs_imgframe">
								<a href="images/assets/docs/box_details.png" class="lightbox" title="Content Box"><img src="images/assets/docs/2.jpg" alt="" /></a>
								<br /><em><strong>Fig. 1.1.</strong> Box details.</em>
							</div>
							<div class="alignright docs_imgframe">
								<a href="images/assets/docs/1.jpg" class="lightbox" title="Content Box Details"><img src="images/assets/docs/0.jpg" alt="" /></a>
								<br /><em><strong>Fig. 1.0.</strong> Content box.</em>
							</div>
							
							<p>
							<code>id="container"</code> - add 20px margin to top and 10px margin to bottom. Also it has a minimum height of 400px to make sure that template will not be destroyed if here are only a few lines of content.</p>
							<p>
							<code>class="container_12"</code> - enable support for 960 grid system. Now once you have added this class your template is fully compatible with 960gs.</p>
							
							<p>All content is recomended(but is not required) to include in "boxes". (Click <strong>Fig. 1.0</strong>)</p><br />
							
							<p><strong>Box HTML structure:</strong></p>
<pre>&lt;section class="grid_4">
	&lt;div class="box">
		&lt;div class="title">Title&lt;/div>						
		&lt;div class="inside">
			&lt;div class="in">
				
				HERE IS ALL CONTENT
				
			&lt;/div>
		&lt;/div>
	&lt;/div>
&lt;/section></pre><br />
							
							<p><strong>So what's that:</strong> (Click <strong>Fig. 1.1</strong>)</p>
							<ol>
								<li>Use 960 grid system to arange the box on page and define the width: <code>&lt;section class="grid_4"> ... &lt;/section></code></li>
								<li>Next create the box itself: <code>&lt;div class="box"> ... &lt;/div></code></li>
								<li>The box will have a title: <code>&lt;div class="title">Title&lt;/div></code> and a div with class <code>"inside"</code> and that in its turn another div with class <code>"in"</code></li>
							</ol>
							
							<p><strong>NOTE:</strong> <code>&lt;div class="in"> here is the content &lt;/div></code> - creates a 10px space around the content. If you wish to have a box without inner space, don't use this div.</p>
							
							<!-- Reference -->
							<div class="docs_refer">
								<strong>Reference:</strong><br /> 
								<ul>
								<li><a href="http://960.gs/" target="_blank">http://960.gs/</a> - 960 grid system official website </li>
								<li><a href="http://www.designinfluences.com/fluid960gs/" target="_blank">http://www.designinfluences.com/fluid960gs/</a> - fluid 960 grid system official website</li>
								</ul>
							</div>
							<!-- /Reference -->
							
							<h4 class="docs_title">Bottom part</h4>
							
							<p>"Bottom part" is a simple addition for you, to have a ready-made footer, if you want to add something to end of a page.</p>
							<br />
							<strong>HTML Structure:</strong><br />
							
<pre>&lt;section id="footer_bar">
	&lt;div class="copyr">Copyright <em>&amp;copy;</em> Smartik 2012&lt;/div>
&lt;/section></pre><br />
							<a href="zForms.php" class="button alignright"><span class="icon16_sprite_green b_right i_arrowhead_right"></span>Forms</a>
							
							<div class="clear"></div>
							</div>
						</div>
					</div>
				</section>
				<div class="clear"></div>
				<!-- ======= .grid_12 - block end ======= -->
				
				
			</section><!-- End of #container -->
			

			
<?php include 'footer.php'; ?>