<?php 
  session_start();	
  $phpFile = $_SERVER["SCRIPT_NAME"];

  include 'includes/initTranslationConfig.php';
  include 'includes/initLogging.php';

?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" lang="en-US">
<head>
	<meta charset="UTF-8" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	
	<title>Declaration-as-a-Service - <?php echo $tr->get('login', 'login') ?></title>
	
	<!-- Global styles -->
	<link rel="stylesheet" type="text/css" href="css/reset.css" />
	<link rel="stylesheet" type="text/css" href="css/grid.css" />
	<link rel="stylesheet" type="text/css" href="css/config.css" />

<!-- = Global Scripts [required for template] 
	***************************************************************************************-->
	<script type="text/javascript" src="js/jquery.js"></script>
	<script type="text/javascript" src="plugins/validator/js/languages/jquery.validationEngine-en.js"></script>
	<script type="text/javascript" src="plugins/validator/js/jquery.validationEngine.js"></script>
	<script>
		jQuery(document).ready(function(){
			jQuery("#admin_login_form").validationEngine('attach', {promptPosition : "bottomRight", autoPositionUpdate : true});
		});
	</script>
	
	
</head>
<body>
	<section id="login_form">
		<div class="login_form_head">Declaration-as-a-Service</div>
		<form id="admin_login_form" class="formee" method="post" action="index.php">
		<div class="login_form_display">
			<div class="login_row"><?php echo $tr->get ('username', 'login') ?><input type="text" class="validate[required,custom[email]]" name="login_username" id="login_username" placeholder="Username" /></div>
			<div class="login_row"><?php echo $tr->get ('password', 'login') ?><input type="password" class="validate[required,custom[passwordLogin]]" name="login_password" id="login_password" placeholder="Password" />
			<small><a href="password_reset.php"><?php echo $tr->get('password_reset', 'login') ?></a></small>
			</div>
			<?php 
			    // TODO: kleur veranderen naar groen
			    if (isset($_GET['failed'])) {
				echo '<font color="#d10000">' . $tr->get('login_failed', 'login') . "</font>";
			    }
			    if (isset($_GET['activation'])) {
				echo '<font color="#d10000">' . $tr->get('activate_first', 'login') . "</font>";
			    }
			    if (isset($_GET['register_ok'])) {
				echo '<font color="#d10000">' . $tr->get('registration_ok', 'login') . "</font>";
			    }
			    if (isset($_GET['activation_failed'])) {
				echo '<font color="#d10000">' . $tr->get('activate_failed', 'login') . "</font>";
			    }
			    if (isset($_GET['activation_succeeded'])) {
				echo '<font color="#d10000">' . $tr->get('activate_succeeded', 'login') . "</font>";
			    }
			?>
			
			<div class="clear"></div>
			<label><a href="register.php"><?php echo $tr->get('register', 'login') ?></a></label>
		</div>
		
		<!--Form footer begin-->
		<section class="login_footer">
			<div class="textcenter"><input type="submit" value="<?php echo $tr->get('login','login') ?>" /></div>
			<div class="clear"></div>
		</section>
		<!--Form footer end-->
			
		</form>					
	</section><!-- End of #container -->

</body>
</html>
