<?php include 'head.php'; ?>

	
			<section id="container" class="container_12">
			
			
				<!-- ======= .grid_12 - block begin ======= -->
				<section class="grid_12">
					<div class="box">
						<div class="title"><div class="layout">Tabs</div></div>						
						<div class="inside">
							<div class="in">
							
							<div class="clear"></div>
							<a href="zProgressbar.php" class="button alignleft"><span class="icon16_sprite_green i_arrowhead_left"></span>Progress bar</a>
							<a href="zAccordion.php" class="button alignright"><span class="icon16_sprite_green b_right i_arrowhead_right"></span>Accordion</a>
							<div class="clear"></div>
							
							<h4 class="docs_title_first">Tabs</h4>
							
							<p>Tabs are generally used to break content into multiple sections that can be swapped to save space, much like an accordion. By default a tab widget will swap between tabbed sections onClick, but the events can be changed to onHover through an option. Tab content can be loaded via Ajax by setting an href on a tab.</p>
							
							<p><strong>How to create Tabs?</strong></p>
							<p><strong>1. Initialize the plugin</strong></p>
<pre>jQuery(function() {
	jQuery(" .ui_tabs ").tabs();
});</pre><br />
							<p><strong>2. Create the HTML using the same class used in the code above:</strong></p><br />
  							
<pre>&lt;div class="ui_tabs">
	...
&lt;/div></pre><br />                          
							
							<p><strong>2.1 Create tabs list:</strong></p><br />
							
<pre>&lt;div class="ui_tabs">
	&lt;ul>
		&lt;li>&lt;a href="#tabs-1">Tabs 1&lt;/a>&lt;/li>
		&lt;li>&lt;a href="#tabs-2">Tab 2&lt;/a>&lt;/li>
		&lt;li>&lt;a href="#tabs-3">Tab 3&lt;/a>&lt;/li>
	&lt;/ul>
&lt;/div></pre><br />


							<p><strong>2.2 Create tabs sections using as ID the same text from tabs list,  <code>href=""</code> attribute:</strong></p><br />
							
																			
<pre>&lt;div <code>class="ui_tabs"</code>>
	&lt;ul>
		&lt;li>&lt;a href="<code>#tabs-1</code>">Tabs 1&lt;/a>&lt;/li>
		&lt;li>&lt;a href="<code>#tabs-2</code>">Tab 2&lt;/a>&lt;/li>
		&lt;li>&lt;a href="<code>#tabs-3</code>">Tab 3&lt;/a>&lt;/li>
	&lt;/ul>
	&lt;div <code>id="tabs-1"</code>>
		&lt;p> THIS IS THE TEXT FOR FIRST TAB&lt;/p>
	&lt;/div>
	&lt;div <code>id="tabs-2"</code>>
		&lt;p> THIS IS THE TEXT FOR SECOND TAB&lt;/p>
	&lt;/div>
	&lt;div <code>id="tabs-3"</code>>
		&lt;p> THIS IS THE TEXT FOR THIRD TAB&lt;/p>
	&lt;/div>
&lt;/div></pre><br />
							
							<div class="docs_result"><span class="docsR_title">The result of the code above:</span>						
								<div class="ui_tabs">
									<ul>
										<li><a href="#tabs-1">Tabs 1</a></li>
										<li><a href="#tabs-2">Tab 2</a></li>
										<li><a href="#tabs-3">Tab 3</a></li>
									</ul>
									<div id="tabs-1">
										<p> THIS IS THE TEXT FOR FIRST TAB</p>
									</div>
									<div id="tabs-2">
										<p> THIS IS THE TEXT FOR SECOND TAB</p>
									</div>
									<div id="tabs-3">
										<p> THIS IS THE TEXT FOR THIRD TAB</p>
									</div>
								</div>
							</div>
							<div class="clear"></div>
							
							
							
							
							<!-- Tabs example 2 -->
							
							<br />
							<h6 class="docs_title_first">How to create Tabs with Navigation aligned to right?</h6><br />
							
							<p>This has a little different structure. The main goal is to create a "tab-ified box".</p>
							<br />
							<p><strong>1. Initialize the plugin</strong></p>
<pre>jQuery(function() {
	jQuery( ".ui_tabs_right" ).tabs();
});</pre><br />


							<p><strong>2. Create a box with class <code>"ui_tabs_right"</code>:</strong></p>
							
<pre>&lt;section class="grid_12">
	&lt;div class=<code>"box <strong>ui_tabs_right</strong>"</code>>
		&lt;div class="title"> Tabs aligned to right &lt;/div>
		
		&lt;div class="inside">
			&lt;div class="in">
				CONTENT TO BE HERE...
			&lt;/div>
		&lt;/div>
		
	&lt;/div>
&lt;/section></pre><br />
							
							
							<p><strong>3. Create tab navigation. You must include it inside of box title:</strong></p>
							
														
<pre>&lt;section class="grid_12">
	&lt;div class="box ui_tabs_right">
		&lt;div class="title"> 
			Tabs aligned to right 
			<code>&lt;ul></code>
				<code>&lt;li>&lt;a href="#tabs-1a">Tab 1&lt;/a>&lt;/li></code>
				<code>&lt;li>&lt;a href="#tabs-2a">Tab 2&lt;/a>&lt;/li></code>
				<code>&lt;li>&lt;a href="#tabs-3a">Tab 3&lt;/a>&lt;/li></code>
			<code>&lt;/ul></code>			
		&lt;/div>
		
		&lt;div class="inside">
			&lt;div class="in">
				CONTENT TO BE HERE...
			&lt;/div>
		&lt;/div>
		
	&lt;/div>
&lt;/section></pre><br />
							
							
							
							<p><strong>4. Create tabs sections using as ID the same text from tabs list,  <code>href=""</code> attribute:</strong></p>
							
														
<pre>&lt;section class="grid_12">
	&lt;div class="box <code>ui_tabs_right</code>">
		&lt;div class="title"> 
			<code>&lt;span class="icon16_sprite i_abacus">&lt;/span></code> &lt;!-- Additional box icon ;) -->
			Tabs aligned to right 
			&lt;ul>
				&lt;li>&lt;a href="<code>#tabs-1a</code>">Tab 1&lt;/a>&lt;/li>
				&lt;li>&lt;a href="<code>#tabs-2a</code>">Tab 2&lt;/a>&lt;/li>
				&lt;li>&lt;a href="<code>#tabs-3a</code>">Tab 3&lt;/a>&lt;/li>
			&lt;/ul>		
		&lt;/div>
		
		&lt;div class="inside">
			&lt;div class="in">
				
				&lt;div id="<code>tabs-1a</code>">
					&lt;div class="grid_12">
						&lt;p>Tabs section 1 content&lt;/p>
					&lt;/div>
				&lt;/div>
				&lt;div id="<code>tabs-2a</code>">
					&lt;div class="grid_12">
						&lt;p>Tabs section 2 content&lt;/p>
					&lt;/div>
				&lt;/div>
				&lt;div id="<code>tabs-3a</code>">
					&lt;div class="grid_12">
						&lt;p>Tabs section 3 content&lt;/p>
					&lt;/div>
				&lt;/div>
				
			&lt;/div>
		&lt;/div>
		
	&lt;/div>
&lt;/section></pre><br />
							
							
							<div class="docs_result"><span class="docsR_title">The result of the code above:</span>						
								<section class="grid_12">
									<div class="box ui_tabs_right">
										<div class="title"> 
											<span class="icon16_sprite i_abacus"></span>
											Tabs aligned to right 
											<ul>
												<li><a href="#tabs-1a">Tab 1</a></li>
												<li><a href="#tabs-2a">Tab 2</a></li>
												<li><a href="#tabs-3a">Tab 3</a></li>
											</ul>		
										</div>
										
										<div class="inside">
											<div class="in">
												
												<div id="tabs-1a">
													<div class="grid_12">
														<p>Tabs section 1 content</p>
													</div>
												</div>
												<div id="tabs-2a">
													<div class="grid_12">
														<p>Tabs section 2 content</p>
													</div>
												</div>
												<div id="tabs-3a">
													<div class="grid_12">
														<p>Tabs section 3 content</p>
													</div>
												</div>
												
											</div>
										</div>
										
									</div>
								</section>
								<div class="clear"></div>
							</div>
							<div class="clear"></div>
		
							<br />
							<h5 class="docs_title_first">Options</h5><br />
							
							<div class="box">
								<div class="title">Main Options</div>								
								<div class="inside">
									<table cellpadding="0" cellspacing="0" border="0" class="display" id="datatable_1docs">
										<thead>
											<tr>
												<th width="15%">OPTION</th>
												<th width="15%">TYPE</th>
												<th width="15%">DEFAULT</th>
												<th width="65%">DESCRIPTION</th>
											</tr>
										</thead>
										<tbody>
										
											<tr class="gradeA odd">
												<td><code>disabled</code></td>  <td><code>Boolean</code></td>  <td><code>false</code></td>
												<td> Disables (true) or enables (false) the tabs. Can be set when initialising (first creating) the tabs. </td>
											</tr>
											
											<tr class="gradeA even">
												<td><code>ajaxOptions</code></td>  <td><code>Options</code></td>  <td><code>null</code></td>
												<td> Additional Ajax options to consider when loading tab content (see $.ajax). </td>
											</tr>
											
											
											<tr class="gradeA odd">
												<td><code>cache</code></td>  <td><code>Boolean</code></td>  <td><code>false</code></td>
												<td> Whether or not to cache remote tabs content, e.g. load only once or with every click. Cached content is being lazy loaded, e.g once and only once for the first click. Note that to prevent the actual Ajax requests from being cached by the browser you need to provide an extra cache: false flag to ajaxOptions. </td>
											</tr>
											
											<tr class="gradeA even">
												<td><code>collapsible</code></td>  <td><code>Boolean</code></td>  <td><code>false</code></td>
												<td> Set to true to allow an already selected tab to become unselected again upon reselection. </td>
											</tr>
											
											<tr class="gradeA odd">
												<td><code>cookie</code></td>  <td><code>Object</code></td>  <td><code>null</code></td>
												<td> Store the latest selected tab in a cookie. The cookie is then used to determine the initially selected tab if the <i>selected</i> option is not defined. Requires <a href="http://plugins.jquery.com/project/cookie" class="external text" title="http://plugins.jquery.com/project/cookie" target="_blank">cookie plugin</a>, which can also be found in the development-bundle&gt;external folder from the download builder. The object needs to have key/value pairs of the form the cookie plugin expects as options. Available options (example): { expires: 7, path: '/', domain: 'jquery.com', secure: true }. Since jQuery UI 1.7 it is also possible to define the cookie name being used via <i>name</i> property. </td>
											</tr>
											
											<tr class="gradeA even">
												<td><code>disabled</code></td>  <td><code>Array</code></td>  <td><code>[]</code></td>
												<td> An array containing the position of the tabs (zero-based index) that should be disabled on initialization. </td>
											</tr>
											
											<tr class="gradeA odd">
												<td><code>event</code></td>  <td><code>String</code></td>  <td><code>click</code></td>
												<td> The type of event to be used for selecting a tab. </td>
											</tr>
											
											<tr class="gradeA even">
												<td><code>fx</code></td>  <td><code>Options, Array</code></td>  <td><code>null</code></td>
												<td> Enable animations for hiding and showing tab panels. The duration option can be a string representing one of the three predefined speeds (<code>"slow"</code>, <code>"normal"</code>, <code>"fast"</code>) or the duration in milliseconds to run an animation (default is <code>"normal"</code>). </td>
											</tr>
											
											<tr class="gradeA odd">
												<td><code>idPrefix</code></td>  <td><code>String</code></td>  <td><code>'ui-tabs-'</code></td>
												<td> If the remote tab, its anchor element that is, has no title attribute to generate an id from, an id/fragment identifier is created from this prefix and a unique id returned by $.data(el), for example "ui-tabs-54". </td>
											</tr>
											
											<tr class="gradeA even">
												<td><code>panelTemplate</code></td>  <td><code>String</code></td>  <td><code>'&lt;div>&lt;/div>'</code></td>
												<td> HTML template from which a new tab panel is created in case of adding a tab with the add method or when creating a panel for a remote tab on the fly. </td>
											</tr>
											
											
											<tr class="gradeA odd">
												<td><code>selected</code></td>  <td><code>Number</code></td>  <td><code>0</code></td>
												<td> Zero-based index of the tab to be selected on initialization. To set all tabs to unselected pass -1 as value. </td>
											</tr>
											
											<tr class="gradeA even">
												<td><code>spinner</code></td>  <td><code>String</code></td>  <td><code>'&lt;em>Loading&#8230;&lt;/em>'</code></td>
												<td> The HTML content of this string is shown in a tab title while remote content is loading. Pass in empty string to deactivate that behavior. An span element must be present in the A tag of the title, for the spinner content to be visible. </td>
											</tr>
												
											<tr class="gradeA odd">
												<td><code>tabTemplate</code></td>  <td><code>String</code></td>  <td><code>'&lt;li&gt;&lt;a href="#{href}"&gt;&lt;span&gt;#{label}&lt;/span&gt;&lt;/a&gt;&lt;/li&gt;'</code></td>
												<td> HTML template from which a new tab is created and added. The placeholders #{href} and #{label} are replaced with the url and tab label that are passed as arguments to the add method. </td>
											</tr>	


											
											
										</tbody>
										<tfoot>
											<tr>
												<th>OPTION</th>
												<th>TYPE</th>
												<th>DEFAULT</th>
												<th>DESCRIPTION</th>
											</tr>
										</tfoot>
									</table>								
									<div class="clear"></div>
								</div>
							</div>
							
							
							<!-- Reference -->
							<div class="docs_refer">
								<strong>Reference:</strong><br /> 
								<ul>
								<li><a href="http://jqueryui.com/demos/tabs/" target="_blank">http://jqueryui.com/demos/tabs/</a> - JQueryUI Tabs plugin official website. For more options and examples, please follow this link. </li>
								</ul>
							</div>
							<!-- /Reference -->
							
							
							<div class="clear"></div>
							<a href="zProgressbar.php" class="button alignleft"><span class="icon16_sprite_green i_arrowhead_left"></span>Progress bar</a>
							<a href="zAccordion.php" class="button alignright"><span class="icon16_sprite_green b_right i_arrowhead_right"></span>Accordion</a>
							<div class="clear"></div>
							</div>
						</div>
					</div>
				</section>
				<div class="clear"></div>
				<!-- ======= .grid_12 - block end ======= -->
				
				
			</section><!-- End of #container -->
			

			
<?php include 'footer.php'; ?>