<?php 
  session_start();
  $phpFile = $_SERVER["SCRIPT_NAME"];
  $msgError = '';

  include 'includes/initLogging.php';
  include 'includes/initTranslationConfig.php';


// ----------------------------
// Initialize ReCaptcha & MongoDB
// ----------------------------
   require_once 'Services/ReCaptcha.php';
   $recaptcha = new Services_ReCaptcha($conf['captcha']['key_public'], $conf['captcha']['key_private']);



// ------------------------------------------
// Entry code: check if valid recover attempt
// ------------------------------------------

    if (isset($_GET['email']) && isset($_GET['key']) && !isset($_POST['submit']) ) {
	// First, check if hash OK
	$post_username = $_GET['email'];
	if (strcmp(hash('sha256', $conf['general']['key_various'] . "reset" . urldecode($_GET['email'])), urldecode($_GET['key'])) == 0) {
	    logMessage($log, 'info', 'COD', $phpFile . ': Hash ok');

	    $mongo = new Mongo();
	    $db = $mongo->declaas;
	    $pwresets = $db->password_resets;

	    logMessage($log, 'info', 'COD', $phpFile . ': Selected DB');


	    // Second, check if recovery was requested, and if so, if not too long ago
	    $res = $pwresets->findOne(array('uid' => $post_username, 'status' => 'requested'), array('date'));
	    logMessage($log, 'info', 'COD', $phpFile . ': Query issued, result for ' . $post_username . ' yields the date' . $res['date']);

	    if ($res['date'] != '') { 
		$datetime1 = new DateTime($res['date']);
	        $datetime2 = new DateTime(date('c'));
		$interval = $datetime1->diff($datetime2);
    
		logMessage($log, 'info', 'COD', $phpFile . ': get: ' . $interval->format('%a') . ' - ' . $interval->format('%h'));

		if (($interval->format('%a') > 0) || ($interval->format('%h') >= 1)) {
		    logMessage($log, 'info', 'BUSSEC', $phpFile . ': Password reset period expired');
		    header('Location: login.php?password_recover_failed=1');
		    exit();
		} else {
		    $pwresets->update(array('uid' => $post_username, 'date' => $res['date']), array('$set' => array('status' => 'validated')) );
		    logMessage($log, 'info', 'BUSSEC', $phpFile . ': Password reset validated');
		    header('Location: login.php?password_reset_validated=1');

		}
	    } else {
		    logMessage($log, 'info', 'BUSSEC', $phpFile . ': No request found in database');
		    header('Location: login.php?password_recover_failed=1');
		    exit();
	    }
	} else {
	    logMessage($log, 'info', 'BUSSEC', $phpFile . ': Invalid recover parameters');
	    header('Location: login.php?password_recover_failed=1');
	    exit();
	}
    }




// ------------------------
// Submit code: afhandeling 
// ------------------------
// TODO: veel code is duplicate met hierboven, kan efficienter

    if (isset($_POST['submit'])) {
	    // *** Store data ***
	    $post_username = (string) trim(strtolower($_POST['field_username']));
	    $post_passwordhash = hash('sha256', $post_username . trim((string) $_POST['field_password']));

	    logMessage($log, 'info', 'COD', $phpFile . ': submit part entered as ' . $post_username);


	    // *** Validated in DB ? ***
	    $mongo = new Mongo();
	    $db = $mongo->declaas;

	    $pwresets = $db->password_resets;
	    // TODO: order desc by date
	    $res = $pwresets->findOne(array('uid' => $post_username, 'status' => 'validated'), array('date'));


	    if ($res['date'] != '') { 
		$datetime1 = new DateTime($res['date']);
	        $datetime2 = new DateTime(date('c'));
		$interval = $datetime1->diff($datetime2);
    
		logMessage($log, 'info', 'COD', $phpFile . ': submit: ' . $interval->format('%a') . ' - ' . $interval->format('%h'));

		if (($interval->format('%a') > 0) || ($interval->format('%h') >= 1)) {
		    logMessage($log, 'info', 'BUSSEC', $phpFile . ': submit: Password recovery period expired');
		    header('Location: login.php?password_recover_failed=1');
		    exit();
		} else {
		    // *** Update het wachtwoord in de tenants db ***
		    // **********************************************
		    $users = $db->users;
		    $users->update(array('uid' => $_GET['email']), array('$set' => array('security.passwdhash' => $post_passwordhash)) );
    		    logMessage($log, 'info', 'BUSCAP', $phpFile . ': Password recovery succesful for user ' . $post_username);

		}
	    } else {
		logMessage($log, 'info', 'BUSSEC', $phpFile . ': Not a validated recovery');
		header('Location: login.php?password_recover_failed=1');
		exit();
	    }



	    // Redirect to OK page
	    header('Location: login.php?password_recover_ok=1');
    	    exit(0);

    }
?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" lang="en-US">
<head>
	<meta charset="UTF-8" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	
	<title>Declaration-as-a-Service - <?php echo $tr->get('register', 'login') ?></title>
	
	<!-- Global styles -->
	<link rel="stylesheet" type="text/css" href="css/reset.css" />
	<link rel="stylesheet" type="text/css" href="css/grid.css" />
	<link rel="stylesheet" type="text/css" href="css/config.css" />

<!-- = Global Scripts [required for template] 
	***************************************************************************************-->
	<script type="text/javascript" src="js/jquery.js"></script>
	<script type="text/javascript" src="plugins/validator/js/languages/jquery.validationEngine-en.js"></script>
	<script type="text/javascript" src="plugins/validator/js/jquery.validationEngine.js"></script>
	<script>
		jQuery(document).ready(function(){
			jQuery("#admin_login_form").validationEngine('attach', {promptPosition : "bottomRight", autoPositionUpdate : true});
		});
	</script>
</head>
<body>


	<section id="login_form" style="width:300px;left:50%;margin-left:-150px;top:20%">
		<div class="login_form_head"><?php echo $tr->get('title', 'password_recover')?></div>
		<form id="admin_login_form" class="formee" method="post">
		<div class="login_form_display">
			    <!-- formee--> 
			    <form id="form_registration" class="formee" method="post" action="registertest.php"> 
				<div class="in"> 
				    <input value=<?php echo '"' . $post_username . '"' ?> type="hidden" name="field_username">
				    <!-- ====================== --> 

				    <div class="grid-4-12"><label>Password: <em class="formee-req">*</em></label></div> 
				    <div class="grid-7-12"> 
					<input value="" class="validate[required,minSize[8]]" type="password" name="field_password" id="field_password" /> 
					<span class="subtip">Any character (min. 8)</span> 
				    </div> 
				    <div class="clear"></div> 
				    
				    <!-- ====================== --> 
									    
				    <div class="grid-4-12"><label>Password (repeat): <em class="formee-req">*</em></label></div> 
				    <div class="grid-7-12"> 
					<input value="" class="validate[required,equals[field_password],minSize[8]]" type="password" name="field_password_confirm" id="field_password_confirm" /> 
					<span class="subtip">Any character (min. 8)</span> 
				    </div> 
				    <div class="clear"></div> 
				    <hr />
				    
				</div><!-- End .in class --> 
				
				
			    
				<!--Form footer begin--> 
				<section class="box_footer"> 
				    <div class="grid-12-12"> 
					<input type="submit" name="submit" class="right button green" value="<?php echo $tr->get('register','login') ?>" /> 
				    </div> 
				    <div class="clear"></div> 
				</section> 
				<!--Form footer end--> 
				
					
			    </form> 
			    <!-- formee--> 
			
		</form>					
	</section><!-- End of #container -->

</body>
</html>
