<?php 
  session_start();
  $phpFile = $_SERVER["SCRIPT_NAME"];
  $msgError = '';

  include 'includes/initLogging.php';
  include 'includes/initTranslationConfig.php';


// ----------------------------
// Initialize ReCaptcha & MongoDB
// ----------------------------
   require_once 'Services/ReCaptcha.php';
   $recaptcha = new Services_ReCaptcha($conf['captcha']['key_public'], $conf['captcha']['key_private']);

   // TODO: datum formaat naar dd-mm-yyyy


// ---------------------
// Submit afhandeling 
// ---------------------

    if (isset($_POST['submit'])) {

	// TODO: check limieten totaal #resets/u 
	// *** Captcha correct ***
	if ($recaptcha->validate()) {
		// *** Store data ***
		$post_username = (string) trim(strtolower($_POST['field_username']));

		$mongo = new Mongo();
		$db = $mongo->declaas;
		$pwresets = $db->password_resets;
		$users = $db->users;

		// Verifieer of de gebruiker bestaat
		$res = $users->findOne(array('uid' => $post_username), array('uid'));

		if ($res['uid'] == '') { // uid bestaat niet
		    // TODO: pop-up / properder
		    logMessage($log, 'info', 'SEC', $phpFile . ': Password reset requested for unexisting user ' . $post_username);
		    header('Location: login.php?password_reset_failed=1');
    		    exit(0);
		}

		// Kijk hoeveel resets al gebeurd
		$count = $pwresets->find(array('uid' => $post_username), array('uid'))->count();
		
		if ($count > $conf['security']['pwreset_threshold']) {
		    // Account blocked
		    // TODO: disable account + foutmelding/properder
		    logMessage($log, 'warn', 'BUSSEC', $phpFile . ': Maximum number of resets reached for user ' . $post_username);
		    header('Location: login.php?password_reset_failed=1');
    		    exit(0);
		}
	    
		// TODO: Check if another is pending


		// Save the reset request with date
		$res = $pwresets->save(array('uid' 	=> $post_username,
					     'date' 	=> new MongoDate(time()),
					     'status' 	=> 'requested')
				      );

		logMessage($log, 'info', 'COD', $phpFile . ': Password reset request saved in DB for user ' . $post_username);


		// TODO: activationkey datum van vandaag toevoegen zodat altijd anere link (per dag)
		// Send password-reset mail
                $message = "To reset your password, please click on this link:\n\n";
		$activationkey = hash('sha256', $conf['general']['key_various'] . "reset" . $post_username);
                $message .= 'https://' . $conf['system']['environment'] . '.' . $conf['system']['domain'] . '/password_recover.php?email=' . urlencode($post_username) . "&key=" . urlencode($activationkey);
                mail($post_username, 'Password Reset Requested', $message, 'From: Declaration-as-a-Service <' . $conf['system']['email'] .'>');

		// Log success
		logMessage($log, 'info', 'SEC', $phpFile . ': Password reset request for user ' . $post_username);

		// Redirect to OK page
		// Te vervangen door pop-up?
		header('Location: login.php?password_reset_ok=1');
    		exit(0);
	} else {
	    logMessage($log, 'warn', 'SEC', $phpFile . ': Captcha validation failed for user ' . trim(strtolower($_POST['field_username'])));
	}

    } else {
        // TODO: wachtwoord niet in password field en username in lastname
    }
    
?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" lang="en-US">
<head>
	<meta charset="UTF-8" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	
	<title>Declaration-as-a-Service - <?php echo $tr->get('register', 'login') ?></title>
	
	<!-- Global styles -->
	<link rel="stylesheet" type="text/css" href="css/reset.css" />
	<link rel="stylesheet" type="text/css" href="css/grid.css" />
	<link rel="stylesheet" type="text/css" href="css/config.css" />

<!-- = Global Scripts [required for template] 
	***************************************************************************************-->
	<script type="text/javascript" src="js/jquery.js"></script>
	<script type="text/javascript" src="plugins/validator/js/languages/jquery.validationEngine-en.js"></script>
	<script type="text/javascript" src="plugins/validator/js/jquery.validationEngine.js"></script>
	<script>
		jQuery(document).ready(function(){
			jQuery("#admin_login_form").validationEngine('attach', {promptPosition : "bottomRight", autoPositionUpdate : true});
		});
	</script>
	
	
</head>
<body>


	<section id="login_form" style="width:600px;left:50%;margin-left:-300px;top:20%">
		<div class="login_form_head"><?php echo $tr->get('title', 'password_reset')?></div>
		<form id="admin_login_form" class="formee" method="post">
		<div class="login_form_display">
			    <!-- formee--> 
			    <form id="form_registration" class="formee" method="post" action="password_reset.php"> 
				<!-- ====== E-MAIL ====== -->
				<div class="in"> 
				    <div class="grid-3-12"><label><?php echo $tr->get('username', 'login') ?>: <em class="formee-req">*</em></label></div> 
				    <div class="grid-7-12"><small>
					<input value=<?php echo '"' . $_POST['field_username'] .'"' ?> class="validate[required,custom[email]]" type="text" name="field_username" id="field_username" /> 
					<span class="subtip"><?php echo $tr->get('tip_username','register') ?></span> </small>
					<?php echo '<br><font color="#d10000">' . $msgError . '</font>'; ?>
				    </div> 
				    <div class="clear"></div> 

				</div><!-- End .in class --> 
				
				
				<!-- ====== CAPTCHA ====== -->
				<div class="grid-3-12"><label>Captcha</label></div>
				<div class="grid-9-12">
				<?php 
				    echo $recaptcha;
				?>
				</div>
			    
				<!--Form footer begin--> 
				<section class="box_footer"> 
				    <div class="grid-12-12"> 
					<input type="submit" name="submit" class="right button green" value="<?php echo $tr->get('reset','password_reset') ?>" /> 
				    </div> 
				    <div class="clear"></div> 
				</section> 
				<!--Form footer end--> 
				
					
			    </form> 
			    <!-- formee--> 
			
		</form>					
	</section><!-- End of #container -->

</body>
</html>
