<?php 
  session_start();
  $phpFile = $_SERVER["SCRIPT_NAME"];
  $msgError = '';

  include 'includes/initLogging.php';
  include 'includes/initTranslationConfig.php';


// ----------------------------
// Initialize ReCaptcha & MongoDB
// ----------------------------
   require_once 'Services/ReCaptcha.php';
   $recaptcha = new Services_ReCaptcha($conf['captcha']['key_public'], $conf['captcha']['key_private']);

   // TODO: datum formaat naar dd-mm-yyyy

// ---------------------
// Submit afhandeling 
// ---------------------

    if (isset($_POST['submit'])) {

	// *** Captcha correct ***
	if ($recaptcha->validate()) {

	    // *** Store data ***
	    $post_username = (string) trim(strtolower($_POST['field_username']));
	    $post_passwordhash = hash('sha256', $post_username . trim((string) $_POST['field_password']));


	    // *** Detecteer dubbel ***
	    $mongo = new Mongo();
	    $db = $mongo->declaas;
	    $users = $db->users;
	    $res = $users->findOne(array('uid' => $post_username), array('uid'));


	    // *** Save als non-existent *** 
	    if ($res['uid'] == '') { // uid nog niet aanwezig => TOEVOEGEN
    		// select the database & collection and get the correct password hash
		$res = $users->save(array('uid'		=> $post_username, 
					'security'	=> array(
					    'passwdhash'	=> $post_passwordhash),

					'status'	=> 'pending',
					'type'		=> 'tenant', // accountmanager, operator, tenant
					'subscription'	=> array(
					    'type' 		=> 'basic',
					    'date_signup'	=> new MongoDate(time())
								),
					'language'	=> (string) $_POST['field_language'],

					'details'	=> array(
    					    'firstname' 	=> (string) $_POST['field_firstname'], 
					    'lastname' 		=> (string) $_POST['field_lastname'],
					    'sex'		=> (string) $_POST['field_sex'],
					    'birthdate'		=> (string) $_POST['field_birthdate'],
					    'street'		=> (string) $_POST['field_street'],
					    'streetnumber'	=> (string) $_POST['field_streetnumber'],
					    'postalcode'	=> (string) $_POST['field_postalcode'],
					    'municipality'	=> (string) $_POST['field_municipality'],
					    'tel'		=> (string) $_POST['field_tel'],
					    'fax'		=> (string) $_POST['field_fax'])

					));
		// TODO: Exception handling



		// Send activation link
                $message = "To activate your account, please click on this link:\n\n";
		$activationkey = hash('sha256', $conf['general']['key_various'] . $post_username);
                $message .= 'http://' . $conf['system']['environment'] . '.' . $conf['system']['domain'] . '/declaas/activate.php?email=' . urlencode($post_username) . "&key=" . urlencode($activationkey);
                mail($post_username, 'Registration Confirmation', $message, 'From: Declaration-as-a-Service <' . $conf['system']['email'] .'>');
		

		// Log success
		logMessage($log, 'info', 'BUSCAP', $phpFile . ': Registration of user ' . $post_username);


		// Redirect to OK page
		header('Location: login.php?register_ok=1');
    		exit(0);

	    }

	    // *** Dubbel ***
	    $msgError = $tr->get('uid_double','register');
	    logMessage($log, 'info', 'SEC', $phpFile . ': Trial of duplicate registration of user ' . $post_username);


	} else {
	    logMessage($log, 'warn', 'SEC', $phpFile . ': Captcha validation failed for user ' . trim(strtolower($_POST['field_username'])));
	    // TODO: wachtwoord niet in password field en username in lastname
	}
    }
?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" lang="en-US">
<head>
	<meta charset="UTF-8" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	
	<title>Declaration-as-a-Service - <?php echo $tr->get('register', 'login') ?></title>
	
	<!-- Global styles -->
	<link rel="stylesheet" type="text/css" href="css/reset.css" />
	<link rel="stylesheet" type="text/css" href="css/grid.css" />
	<link rel="stylesheet" type="text/css" href="css/config.css" />

<!-- = Global Scripts [required for template] 
	***************************************************************************************-->
	<script type="text/javascript" src="js/jquery.js"></script>
	<script type="text/javascript" src="plugins/validator/js/languages/jquery.validationEngine-en.js"></script>
	<script type="text/javascript" src="plugins/validator/js/jquery.validationEngine.js"></script>
	<script>
		jQuery(document).ready(function(){
			jQuery("#admin_login_form").validationEngine('attach', {promptPosition : "bottomRight", autoPositionUpdate : true});
		});
	</script>
	
	
</head>
<body>


	<section id="login_form" style="width:600px;left:50%;margin-left:-300px;top:20%">
		<div class="login_form_head"><?php echo $tr->get('registration_form', 'register')?></div>
		<form id="admin_login_form" class="formee" method="post">
		<div class="login_form_display">
			    <!-- formee--> 
			    <form id="form_registration" class="formee" method="post" action="register.php"> 
				<div class="in"> 
				    <div class="grid-3-12"><label><?php echo $tr->get('username', 'login') ?>: <em class="formee-req">*</em></label></div> 
				    <div class="grid-7-12"><small>
					<input value=<?php echo '"' . $_POST['field_username'] .'"' ?> class="validate[required,custom[email]]" type="text" name="field_username" id="field_username" /> 
					<span class="subtip"><?php echo $tr->get('tip_username','register') ?></span> </small>
					<?php echo '<br><font color="#d10000">' . $msgError . '</font>'; ?>
				    </div> 
				    <div class="clear"></div> 
				    
				    
				    
				    <!-- ====================== --> 
									    
				    <div class="grid-3-12"><label>Password: <em class="formee-req">*</em></label></div> 
				    <div class="grid-4-12"> 
					<input value="" class="validate[required,minSize[8]]" type="password" name="field_password" id="field_password" /> 
					<span class="subtip">Any character (min. 8)</span> 
				    </div> 
				    <div class="clear"></div> 
				    
				    <!-- ====================== --> 
									    
				    <div class="grid-3-12"><label>Password (repeat): <em class="formee-req">*</em></label></div> 
				    <div class="grid-4-12"> 
					<input value="" class="validate[required,equals[field_password],minSize[8]]" type="password" name="field_password_confirm" id="field_password_confirm" /> 
					<span class="subtip">Any character (min. 8)</span> 
				    </div> 
				    <div class="clear"></div> 
				    <hr />
				    
				    <!-- ====================== --> 
				    
				    <div class="grid-3-12"><label>First name: <em class="formee-req">*</em></label></div> 
				    <div class="grid-7-12"> 
					<input value=<?php echo '"' . $_POST['field_firstname'] .'"' ?> class="validate[required,custom[firstName]]" type="text" name="field_firstname" id="field_firstname" /> 
					<span class="subtip">Only letters accepted</span> 
				    </div> 
				    <div class="clear"></div> 
				    
				    <!-- ====================== --> 
				    
				    <div class="grid-3-12"><label>Last name: <em class="formee-req">*</em></label></div> 
				    <div class="grid-7-12"> 
					<input value=<?php echo '"' . $_POST['field_lastname'] .'"' ?> class="validate[required,custom[lastName]]" type="text" name="field_lastname" id="field_lastname" /> 
					<span class="subtip">Only letters accepted</span> 
				    </div> 
				    <div class="clear"></div> 
				    <!-- ====================== --> 
				    <div class="grid-3-12"><label>Sex: </label></div>
					<div class="grid-4-12">
					<ul class="formee-list">
					    <li><input name="field_sex" type="radio" <?php if ($_POST['field_sex'] == 'M') {echo 'checked="checked"';} ?> value="M" /><label>Male</label></li>
					    <li><input name="field_sex" type="radio" <?php if ($_POST['field_sex'] == 'F') {echo 'checked="checked"';} ?> value="F" /><label>Female</label></li>
					</ul>
				    </div>
				    <div class="clear"></div>

				    <!-- ==== LANGUAGE ====== -->
				    <div class="grid-3-12"><label>Language:</label></div>
					<div class="grid-4-12">
					<select class="chzn-select" style="max-width:350px;" name="field_language">
					    <option value="en" <?php if ($_POST['field_language'] == 'en') {echo 'selected="selected"';} ?>>English</option>.
					    <option value="fr" <?php if ($_POST['field_language'] == 'fr') {echo 'selected="selected"';} ?>>Francais</option>.
					    <option value="nl" <?php if ($_POST['field_language'] == 'nl') {echo 'selected="selected"';} ?>>Nederlands</option>.
					</select>
					</div>
				    <div class="clear"></div>


				    <!-- ==== BIRTHDATE ====== -->
				    <div class="grid-3-12"><label>Birth date: <em class="formee-req">*</em></label></div>
				    <div class="grid-4-12">
				    <input type="text" name="field_birthdate" id="field_birthdate" class="validate[required,custom[date]]" value=<?php echo '"' . $_POST['field_birthdate'] .'"' ?> />
				    <span class="subtip">TODO: Voorbeeld: 2012-01-17</span>
				    </div>
				    <div class="clear"></div>
				    <hr />

				    <!-- ==== STREET ========== -->
				    <div class="grid-3-12"><label>Street: </label></div>
				    <div class="grid-9-12"><input type="text" name="field_street" value=<?php echo '"' . $_POST['field_street'] .'"' ?> /></div>
				    <div class="clear"></div>

				    <!-- ==== NUMMER ========== -->
				    <div class="grid-3-12"><label>Number: <em class="formee-req">*</em></label></div>
				    <div class="grid-2-12">
				    <input type="text" name="field_streetnumber" id="field_number" class="validate[required,custom[integer]]" value=<?php echo '"' . $_POST['field_streetnumber'] .'"' ?>/>
				    <span class="subtip">Number</span>
				    </div>
				    <div class="clear"></div>

				    <!-- ==== POSTAL CODE ===== -->
				    <div class="grid-3-12"><label>Postal code & municipality: <em class="formee-req">*</em></label></div>
				    <div class="grid-2-12">
				    <input type="text" name="field_postalcode" id="field_postalcode" class="validate[required,custom[integer]]" value=<?php echo '"' . $_POST['field_postalcode'] .'"' ?>/>
				    <span class="subtip">Number</span>
				    </div>
<!--				    <div class="clear"></div> -->

				    <!-- ==== GEMEENTE ======== -->
<!-- 				    <div class="grid-3-12"><label>Municipality: </label></div> -->
				    <div class="grid-7-12"><input type="text" name="field_municipality" value=<?php echo '"' . $_POST['field_municipality'] .'"' ?>/></div>
				    <div class="clear"></div>
				    
				    <!-- ==== TEL ============= -->
				    <div class="grid-3-12"><label>Telephone: </label></div>
				    <div class="grid-3-12"><input type="text" name="field_tel" placeholder="+3222405055" value=<?php echo '"' . $_POST['field_tel'] .'"' ?>/></div>
				    <div class="clear"></div> 

				    <!-- ==== FAX ============= -->
				    <div class="grid-3-12"><label>Fax: </label></div>
				    <div class="grid-3-12"><input type="text" name="field_fax" placeholder="+3222405080" value=<?php echo '"' . $_POST['field_fax'] .'"' ?> /></div>
				    <div class="clear"></div>
				    <hr />

				</div><!-- End .in class --> 
				
				
				    <!-- ====== CAPTCHA ====== -->
				<div class="grid-3-12"><label>Captcha</label></div>
				<div class="grid-9-12">
				<?php 
				    echo $recaptcha;
				?>
				</div>
			    
				<!--Form footer begin--> 
				<section class="box_footer"> 
				    <div class="grid-12-12"> 
					<input type="submit" name="submit" class="right button green" value="<?php echo $tr->get('register','login') ?>" /> 
				    </div> 
				    <div class="clear"></div> 
				</section> 
				<!--Form footer end--> 
				
					
			    </form> 
			    <!-- formee--> 
			
		</form>					
	</section><!-- End of #container -->

</body>
</html>
