<?php
/**
 * Widget Muffin Recent Posts
 *
 * @package Bretheon
 * @author Muffin group
 * @link http://muffingroup.com
 */

class Mfn_Recent_Posts_Widget extends WP_Widget {

	
	/* ---------------------------------------------------------------------------
	 * Constructor
	 * --------------------------------------------------------------------------- */
	function Mfn_Recent_Posts_Widget() {
		$widget_ops = array( 'classname' => 'widget_mfn_recent_posts', 'description' => __( 'The most recent posts on your site.', 'mfn-opts' ) );
		$this->WP_Widget( 'widget_mfn_recent_posts', __( 'Muffin Recent Posts', 'mfn-opts' ), $widget_ops );
		$this->alt_option_name = 'widget_mfn_recent_posts';
	}
	
	
	/* ---------------------------------------------------------------------------
	 * Outputs the HTML for this widget.
	 * --------------------------------------------------------------------------- */
	function widget( $args, $instance ) {

		if ( ! isset( $args['widget_id'] ) ) $args['widget_id'] = null;
		extract( $args, EXTR_SKIP );

		echo $before_widget;
		
		$title = apply_filters( 'widget_title', $instance['title'], $instance, $this->id_base);
		if( $title ) echo $before_title . $title . $after_title;
		
		$aPosts = get_posts( 'showposts='. intval($instance['count']) );
		if(is_array($aPosts))
		{           
			$output = '<div class="Latest_posts">';
				$output .= '<ul>';
					foreach($aPosts as $post)
					{
						$output .= '<li>';
							if( has_post_thumbnail( $post->ID ) ){
								$output .= '<div class="photo">';
									$output .= get_the_post_thumbnail( $post->ID, 'blog-widget' );
									$output .= '<span class="comments">'. $post->comment_count .'</span>';
								$output .= '</div>';
							}
							if( has_post_thumbnail( $post->ID ) ) $output .= '<div class="desc">'; else $output .= '<div class="desc no_img">';
								$output .= '<h6><a class="title" href="'. get_permalink( $post->ID ) .'">'. $post->post_title .'</a></h6>';
								$output .= '<span class="date"><i class="icon-calendar"></i> '. get_the_time('F j, Y', $post->ID) .'</span>';
	                       	$output .= '</div>';
                       	$output .= '</li>';
					}
				$output .= '</ul>';
			$output .= '</div>'."\n";
		}
		echo $output;

		echo $after_widget;
	}


	/* ---------------------------------------------------------------------------
	 * Deals with the settings when they are saved by the admin.
	 * --------------------------------------------------------------------------- */
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['count'] = (int) $new_instance['count'];
		
		return $instance;
	}

	
	/* ---------------------------------------------------------------------------
	 * Displays the form for this widget on the Widgets page of the WP Admin area.
	 * --------------------------------------------------------------------------- */
	function form( $instance ) {
		
		$title = isset( $instance['title']) ? esc_attr( $instance['title'] ) : '';
		$count = isset( $instance['count'] ) ? absint( $instance['count'] ) : 2;

		?>
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php _e( 'Title:', 'mfn-opts' ); ?></label>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
			</p>
			
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'count' ) ); ?>"><?php _e( 'Number of posts:', 'mfn-opts' ); ?></label>
				<input id="<?php echo esc_attr( $this->get_field_id( 'count' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'count' ) ); ?>" type="text" value="<?php echo esc_attr( $count ); ?>" size="3"/>
			</p>
			
		<?php
	}
}
?>